/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wms.GetMapRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.CanonicalSet;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class QuickTileCache
implements TransactionListener,
GeoServerLifecycleHandler {
    private static final Set ignoredParameters = new HashSet();
    private CanonicalSet<MetaTileKey> metaTileKeys = CanonicalSet.newInstance(MetaTileKey.class);
    private WeakHashMap tileCache = new WeakHashMap();

    public QuickTileCache(GeoServer geoServer) {
        geoServer.addListener((ConfigurationListener)new ConfigurationListenerAdapter(){

            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                QuickTileCache.this.tileCache.clear();
            }

            public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                QuickTileCache.this.tileCache.clear();
            }

            public void reloaded() {
                QuickTileCache.this.tileCache.clear();
            }
        });
    }

    QuickTileCache() {
    }

    public MetaTileKey getMetaTileKey(GetMapRequest request) {
        String mapDefinition = this.buildMapDefinition(request.getRawKvp());
        ReferencedEnvelope bbox = new ReferencedEnvelope(request.getBbox(), request.getCrs());
        Point2D origin = request.getTilesOrigin();
        if (CRS.getAxisOrder((CoordinateReferenceSystem)request.getCrs()) == CRS.AxisOrder.NORTH_EAST) {
            try {
                bbox = new ReferencedEnvelope(bbox.getMinY(), bbox.getMaxY(), bbox.getMinX(), bbox.getMaxX(), CRS.decode((String)("EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)request.getCrs(), (boolean)false))));
                origin = new Point2D.Double(origin.getY(), origin.getX());
            }
            catch (Exception e) {
                throw new ServiceException("Failed to bring the bbox back in a EN order", (Throwable)e);
            }
        }
        MapKey mapKey = new MapKey(mapDefinition, QuickTileCache.normalize(bbox.getWidth() / (double)request.getWidth()), origin);
        Point tileCoords = this.getTileCoordinates((Envelope)bbox, origin);
        Point metaTileCoords = this.getMetaTileCoordinates(tileCoords);
        ReferencedEnvelope metaTileEnvelope = this.getMetaTileEnvelope(bbox, tileCoords, metaTileCoords);
        MetaTileKey key = new MetaTileKey(mapKey, metaTileCoords, metaTileEnvelope);
        return (MetaTileKey)this.metaTileKeys.unique((Object)key);
    }

    private ReferencedEnvelope getMetaTileEnvelope(ReferencedEnvelope bbox, Point tileCoords, Point metaTileCoords) {
        double minx = bbox.getMinX() + (double)(metaTileCoords.x - tileCoords.x) * bbox.getWidth();
        double miny = bbox.getMinY() + (double)(metaTileCoords.y - tileCoords.y) * bbox.getHeight();
        double maxx = minx + bbox.getWidth() * 3.0;
        double maxy = miny + bbox.getHeight() * 3.0;
        return new ReferencedEnvelope(minx, maxx, miny, maxy, bbox.getCoordinateReferenceSystem());
    }

    Point getMetaTileCoordinates(Point tileCoords) {
        int mtx;
        int x = tileCoords.x;
        int y = tileCoords.y;
        int rx = x % 3;
        int ry = y % 3;
        int n = rx == 0 ? x : (mtx = x >= 0 ? x - rx : x - 3 - rx);
        int mty = ry == 0 ? y : (y >= 0 ? y - ry : y - 3 - ry);
        return new Point(mtx, mty);
    }

    Point getTileCoordinates(Envelope env, Point2D origin) {
        double centerx = env.getMinX() + env.getWidth() / 2.0;
        double centery = env.getMinY() + env.getHeight() / 2.0;
        int x = (int)Math.floor((centerx - origin.getX()) / env.getWidth());
        int y = (int)Math.floor((centery - origin.getY()) / env.getWidth());
        return new Point(x, y);
    }

    static double normalize(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        return (double)Math.round(d * 1.0E7) / 1.0E7;
    }

    private String buildMapDefinition(Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            String paramName = en.getKey();
            if (ignoredParameters.contains(paramName.toUpperCase())) continue;
            sb.append(paramName).append('=').append(en.getValue());
            if (!it.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    public synchronized RenderedImage getTile(MetaTileKey key, GetMapRequest request) {
        CacheElement ce = (CacheElement)this.tileCache.get(key);
        if (ce == null) {
            return null;
        }
        return this.getTile(key, request, ce.tiles);
    }

    public RenderedImage getTile(MetaTileKey key, GetMapRequest request, RenderedImage[] tiles) {
        Envelope bbox = request.getBbox();
        if (CRS.getAxisOrder((CoordinateReferenceSystem)request.getCrs()) == CRS.AxisOrder.NORTH_EAST) {
            bbox = new Envelope(bbox.getMinY(), bbox.getMaxY(), bbox.getMinX(), bbox.getMaxX());
        }
        Point tileCoord = this.getTileCoordinates(bbox, key.mapKey.origin);
        Point metaCoord = key.metaTileCoords;
        return tiles[tileCoord.x - metaCoord.x + (tileCoord.y - metaCoord.y) * key.getMetaFactor()];
    }

    public synchronized void storeTiles(MetaTileKey key, RenderedImage[] tiles) {
        this.tileCache.put(key, new CacheElement(tiles));
    }

    public void dataStoreChange(TransactionEvent event) throws WFSException {
        this.tileCache.clear();
    }

    public void onReset() {
        this.tileCache.clear();
    }

    public void onDispose() {
        this.tileCache.clear();
    }

    public void onReload() {
        this.tileCache.clear();
    }

    static {
        ignoredParameters.add("REQUEST");
        ignoredParameters.add("TILED");
        ignoredParameters.add("BBOX");
        ignoredParameters.add("WIDTH");
        ignoredParameters.add("HEIGHT");
        ignoredParameters.add("SERVICE");
        ignoredParameters.add("VERSION");
        ignoredParameters.add("EXCEPTIONS");
    }

    class CacheElement {
        RenderedImage[] tiles;

        public CacheElement(RenderedImage[] tiles) {
            this.tiles = tiles;
        }
    }

    static class MetaTileKey {
        MapKey mapKey;
        Point metaTileCoords;
        ReferencedEnvelope metaTileEnvelope;

        public MetaTileKey(MapKey mapKey, Point metaTileCoords, ReferencedEnvelope metaTileEnvelope) {
            this.mapKey = mapKey;
            this.metaTileCoords = metaTileCoords;
            this.metaTileEnvelope = metaTileEnvelope;
        }

        public ReferencedEnvelope getMetaTileEnvelope() {
            return this.metaTileEnvelope;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.mapKey).append((Object)this.metaTileCoords).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetaTileKey)) {
                return false;
            }
            MetaTileKey other = (MetaTileKey)obj;
            return new EqualsBuilder().append((Object)this.mapKey, (Object)other.mapKey).append((Object)this.metaTileCoords, (Object)other.metaTileCoords).isEquals();
        }

        public int getMetaFactor() {
            return 3;
        }

        public int getTileSize() {
            return 256;
        }

        public String toString() {
            return this.mapKey + "\nmtc:" + this.metaTileCoords.x + "," + this.metaTileCoords.y;
        }
    }

    static class MapKey {
        String mapDefinition;
        double resolution;
        Point2D origin;

        public MapKey(String mapDefinition, double resolution, Point2D origin) {
            this.mapDefinition = mapDefinition;
            this.resolution = resolution;
            this.origin = origin;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.mapDefinition).append(this.resolution).append(this.resolution).append((Object)this.origin).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapKey)) {
                return false;
            }
            MapKey other = (MapKey)obj;
            return new EqualsBuilder().append((Object)this.mapDefinition, (Object)other.mapDefinition).append(this.resolution, other.resolution).append((Object)this.origin, (Object)other.origin).isEquals();
        }

        public String toString() {
            return this.mapDefinition + "\nw:" + "\nresolution:" + this.resolution + "\norig:" + this.origin.getX() + "," + this.origin.getY();
        }
    }
}

