/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.IOException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.AbstractMapOutputFormat;

public class PDFMapOutputFormat
extends AbstractMapOutputFormat {
    static final String MIME_TYPE = "application/pdf";
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(false, false, false, true, null);

    public PDFMapOutputFormat() {
        super(MIME_TYPE);
    }

    @Override
    public PDFMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        PDFMap result = new PDFMap(mapContent);
        result.setContentDispositionHeader(mapContent, ".pdf");
        result.setMimeType(MIME_TYPE);
        return result;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return CAPABILITIES;
    }

    public static class PDFMap
    extends WebMap {
        public PDFMap(WMSMapContent mapContent) {
            super(mapContent);
        }

        public WMSMapContent getContext() {
            return this.mapContent;
        }
    }
}

