/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import org.geoserver.wms.legendgraphic.ColorMapEntryLegendBuilder;
import org.geoserver.wms.legendgraphic.GradientColorManager;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.TextManager;
import org.geotools.styling.ColorMapEntry;

class RampColorMapEntryLegendBuilder
extends ColorMapEntryLegendBuilder {
    public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
        Color previousColor;
        ColorMapEntry previousCME = mapEntries.get(0);
        ColorMapEntry currentCME = mapEntries.get(1);
        boolean leftEdge = previousCME == null;
        if (!leftEdge) {
            previousColor = LegendUtils.color(previousCME);
            double opacity = LegendUtils.getOpacity(previousCME);
            previousColor = new Color(previousColor.getRed(), previousColor.getGreen(), previousColor.getBlue(), (int)(255.0 * opacity + 0.5));
        } else {
            previousColor = null;
        }
        Color color = LegendUtils.color(currentCME);
        double opacity = LegendUtils.getOpacity(currentCME);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
        super.add(new GradientColorManager(color, opacity, previousColor, requestedDimension, borderColor));
        String label = currentCME.getLabel();
        double quantity = LegendUtils.getQuantity(currentCME);
        String symbol = leftEdge ? " > " : " = ";
        String rule = leftEdge ? Double.toString(quantity) + " " + symbol + " x" : Double.toString(quantity) + " " + symbol + " x";
        super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
        if (label != null) {
            this.hasLabel = true;
            super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
        } else {
            super.add(null);
        }
    }
}

