/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class FeatureCollectionDecorator
implements FeatureCollection<FeatureType, Feature> {
    protected FeatureCollection fc;
    protected Name name;

    public static Name getName(FeatureCollection fc) {
        if (fc instanceof FeatureCollectionDecorator) {
            return ((FeatureCollectionDecorator)fc).getName();
        }
        return fc.getSchema().getName();
    }

    public FeatureCollectionDecorator(Name name, FeatureCollection fc) {
        this.name = name;
        this.fc = fc;
    }

    public Name getName() {
        return this.name;
    }

    public FeatureIterator<Feature> features() {
        return this.fc.features();
    }

    public void close(FeatureIterator<Feature> close) {
        this.fc.close(close);
    }

    public void close(Iterator<Feature> close) {
        this.fc.close(close);
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.fc.addListener(listener);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.fc.removeListener(listener);
    }

    public FeatureType getSchema() {
        return this.fc.getSchema();
    }

    public String getID() {
        return this.fc.getID();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.fc.accepts(visitor, progress);
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        return this.fc.subCollection(filter);
    }

    public FeatureCollection<FeatureType, Feature> sort(SortBy order) {
        return this.fc.sort(order);
    }

    public ReferencedEnvelope getBounds() {
        return this.fc.getBounds();
    }

    public Iterator<Feature> iterator() {
        return this.fc.iterator();
    }

    public void purge() {
        this.fc.purge();
    }

    public boolean add(Feature obj) {
        return this.fc.add(obj);
    }

    public boolean addAll(Collection<? extends Feature> collection) {
        return this.fc.addAll(collection);
    }

    public boolean addAll(FeatureCollection<? extends FeatureType, ? extends Feature> resource) {
        return this.fc.addAll(resource);
    }

    public void clear() {
        this.fc.clear();
    }

    public boolean contains(Object o) {
        return this.fc.contains(o);
    }

    public boolean containsAll(Collection<?> o) {
        return this.fc.containsAll(o);
    }

    public boolean isEmpty() {
        return this.fc.isEmpty();
    }

    public boolean remove(Object o) {
        return this.fc.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return this.fc.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.fc.retainAll(c);
    }

    public int size() {
        FeatureIterator<Feature> iterator = this.features();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public Object[] toArray() {
        return this.fc.toArray();
    }

    public <O> O[] toArray(O[] a) {
        return this.fc.toArray((Object[])a);
    }
}

