/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.temporal.object.DefaultPeriodDuration;
import org.geotools.util.logging.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

abstract class DimensionHelper {
    static final Logger LOGGER = Logging.getLogger(DimensionHelper.class);
    Mode mode;
    WMS wms;

    public DimensionHelper(Mode mode, WMS wms) {
        this.mode = mode;
        this.wms = wms;
    }

    protected abstract void element(String var1, String var2);

    protected abstract void element(String var1, String var2, Attributes var3);

    void handleVectorLayerDimensions(LayerInfo layer) {
        boolean hasElevation;
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)layer.getResource();
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        DimensionInfo elevInfo = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        boolean hasTime = timeInfo != null && timeInfo.isEnabled();
        boolean bl = hasElevation = elevInfo != null && elevInfo.isEnabled();
        if (!hasTime && !hasElevation) {
            return;
        }
        if (this.mode == Mode.WMS11) {
            this.declareWMS11Dimensions(hasTime, hasElevation);
        }
        if (hasTime) {
            try {
                this.handleTimeDimensionVector(typeInfo);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to handle time attribute for layer", e);
            }
        }
        if (hasElevation) {
            try {
                this.handleElevationDimensionVector(typeInfo);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void handleRasterLayerDimensions(LayerInfo layer) throws RuntimeException {
        boolean hasElevation;
        CoverageInfo cvInfo = (CoverageInfo)layer.getResource();
        DimensionInfo timeInfo = (DimensionInfo)cvInfo.getMetadata().get("time", DimensionInfo.class);
        DimensionInfo elevInfo = (DimensionInfo)cvInfo.getMetadata().get("elevation", DimensionInfo.class);
        boolean hasTime = timeInfo != null && timeInfo.isEnabled();
        boolean bl = hasElevation = elevInfo != null && elevInfo.isEnabled();
        if (!hasTime && !hasElevation) {
            return;
        }
        if (cvInfo == null) {
            throw new ServiceException("Unable to acquire coverage resource for layer: " + layer.getName());
        }
        Catalog catalog = cvInfo.getCatalog();
        if (catalog == null) {
            throw new ServiceException("Unable to acquire catalog resource for layer: " + layer.getName());
        }
        CoverageStoreInfo csinfo = cvInfo.getStore();
        if (csinfo == null) {
            throw new ServiceException("Unable to acquire coverage store resource for layer: " + layer.getName());
        }
        AbstractGridCoverage2DReader reader = null;
        try {
            reader = (AbstractGridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName(), t);
        }
        if (reader == null) {
            throw new ServiceException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        if (this.mode == Mode.WMS11) {
            this.declareWMS11Dimensions(hasTime, hasElevation);
        }
        if (hasTime && dimensions.hasTime()) {
            this.handleTimeDimensionRaster(timeInfo, dimensions);
        }
        if (hasElevation && dimensions.hasElevation()) {
            this.handleElevationDimensionRaster(elevInfo, dimensions);
        }
    }

    private void handleElevationDimensionRaster(DimensionInfo elevInfo, ReaderDimensionsAccessor dimensions) {
        TreeSet elevations = dimensions.getElevationDomain();
        String elevationMetadata = this.getZDomainRepresentation(elevInfo, elevations);
        this.writeElevationDimension(elevations, elevationMetadata);
    }

    private void handleTimeDimensionRaster(DimensionInfo timeInfo, ReaderDimensionsAccessor dimension) {
        TreeSet temporalDomain = dimension.getTimeDomain();
        String timeMetadata = this.getTemporalDomainRepresentation(timeInfo, temporalDomain);
        this.writeTimeDimension(timeMetadata);
    }

    private void declareWMS11Dimensions(boolean hasTime, boolean hasElevation) {
        if (hasTime) {
            AttributesImpl timeDim = new AttributesImpl();
            timeDim.addAttribute("", "name", "name", "", "time");
            timeDim.addAttribute("", "units", "units", "", "ISO8601");
            this.element("Dimension", null, timeDim);
        }
        if (hasElevation) {
            AttributesImpl elevDim = new AttributesImpl();
            elevDim.addAttribute("", "name", "name", "", "elevation");
            elevDim.addAttribute("", "units", "units", "", "EPSG:5030");
            this.element("Dimension", null, elevDim);
        }
    }

    protected String getZDomainRepresentation(DimensionInfo dimension, TreeSet<Double> values) {
        String elevationMetadata = null;
        StringBuilder buff = new StringBuilder();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (Double val : values) {
                buff.append(val);
                buff.append(",");
            }
            elevationMetadata = buff.substring(0, buff.length() - 1).toString().replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "");
        } else if (DimensionPresentation.CONTINUOUS_INTERVAL == dimension.getPresentation()) {
            buff.append(values.first());
            buff.append("/");
            buff.append(values.last());
            buff.append("/");
            Double resolution = values.last() - values.first();
            buff.append(resolution);
            elevationMetadata = buff.toString();
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            buff.append(values.first());
            buff.append("/");
            buff.append(values.last());
            buff.append("/");
            BigDecimal resolution = dimension.getResolution();
            if (resolution != null) {
                buff.append(resolution.doubleValue());
            } else if (values.size() >= 2) {
                int count = 2;
                int i = 2;
                Double[] zPositions = new Double[count];
                for (Double val : values) {
                    zPositions[count - i--] = val;
                    if (i != 0) continue;
                    break;
                }
                double span = zPositions[count - 1] - zPositions[count - 2];
                buff.append(span);
            } else {
                buff.append(0.0);
            }
            elevationMetadata = buff.toString();
        }
        return elevationMetadata;
    }

    String getTemporalDomainRepresentation(DimensionInfo dimension, TreeSet<Date> values) {
        String timeMetadata = null;
        StringBuilder buff = new StringBuilder();
        ISO8601Formatter df = new ISO8601Formatter();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (Date date : values) {
                buff.append(df.format(date));
                buff.append(",");
            }
            timeMetadata = buff.substring(0, buff.length() - 1).toString().replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "");
        } else if (DimensionPresentation.CONTINUOUS_INTERVAL == dimension.getPresentation()) {
            buff.append(df.format(values.first()));
            buff.append("/");
            buff.append(df.format(values.last()));
            buff.append("/");
            long durationInMilliSeconds = values.last().getTime() - values.first().getTime();
            buff.append(new DefaultPeriodDuration(durationInMilliSeconds).toString());
            timeMetadata = buff.toString();
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            buff.append(df.format(values.first()));
            buff.append("/");
            buff.append(df.format(values.last()));
            buff.append("/");
            BigDecimal resolution = dimension.getResolution();
            if (resolution != null) {
                buff.append(new DefaultPeriodDuration(resolution.longValue()).toString());
            } else if (values.size() >= 2) {
                int count = 2;
                int i = 2;
                Date[] timePositions = new Date[count];
                for (Date date : values) {
                    timePositions[count - i--] = date;
                    if (i != 0) continue;
                    break;
                }
                long durationInMilliSeconds = timePositions[count - 1].getTime() - timePositions[count - 2].getTime();
                buff.append(new DefaultPeriodDuration(durationInMilliSeconds).toString());
            } else {
                buff.append(new DefaultPeriodDuration(0L).toString());
            }
            timeMetadata = buff.toString();
        }
        return timeMetadata;
    }

    private void handleTimeDimensionVector(FeatureTypeInfo typeInfo) throws IOException {
        String timeMetadata;
        TreeSet<Date> values = this.wms.getFeatureTypeTimes(typeInfo);
        if (values != null && !values.isEmpty()) {
            DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
            timeMetadata = this.getTemporalDomainRepresentation(timeInfo, values);
        } else {
            timeMetadata = "";
        }
        this.writeTimeDimension(timeMetadata);
    }

    private void handleElevationDimensionVector(FeatureTypeInfo typeInfo) throws IOException {
        String elevationMetadata;
        TreeSet<Double> elevations = this.wms.getFeatureTypeElevations(typeInfo);
        if (elevations != null && !elevations.isEmpty()) {
            DimensionInfo di = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
            elevationMetadata = this.getZDomainRepresentation(di, elevations);
        } else {
            elevationMetadata = "";
        }
        this.writeElevationDimension(elevations, elevationMetadata);
    }

    private void writeTimeDimension(String timeMetadata) {
        AttributesImpl timeDim = new AttributesImpl();
        if (this.mode == Mode.WMS11) {
            timeDim.addAttribute("", "name", "name", "", "time");
            timeDim.addAttribute("", "default", "default", "", "current");
            this.element("Extent", timeMetadata, timeDim);
        } else {
            timeDim.addAttribute("", "name", "name", "", "time");
            timeDim.addAttribute("", "default", "default", "", "current");
            timeDim.addAttribute("", "units", "units", "", "ISO8601");
            this.element("Dimension", timeMetadata, timeDim);
        }
    }

    private void writeElevationDimension(TreeSet<Double> elevations, String elevationMetadata) {
        AttributesImpl elevDim = new AttributesImpl();
        Double defaultValue = elevations == null || elevations.isEmpty() ? 0.0 : elevations.first();
        if (this.mode == Mode.WMS11) {
            elevDim.addAttribute("", "name", "name", "", "elevation");
            elevDim.addAttribute("", "default", "default", "", Double.toString(defaultValue));
            this.element("Extent", elevationMetadata, elevDim);
        } else {
            elevDim.addAttribute("", "name", "name", "", "elevation");
            elevDim.addAttribute("", "default", "default", "", Double.toString(defaultValue));
            elevDim.addAttribute("", "units", "units", "", "EPSG:5030");
            elevDim.addAttribute("", "unitSymbol", "unitSymbol", "", "m");
            this.element("Dimension", elevationMetadata, elevDim);
        }
    }

    static class ISO8601Formatter {
        private final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));

        ISO8601Formatter() {
        }

        private void pad(StringBuilder buf, int value, int amt) {
            if (amt == 2 && value < 10) {
                buf.append('0');
            } else if (amt == 4 && value < 1000) {
                if (value >= 100) {
                    buf.append("0");
                } else if (value >= 10) {
                    buf.append("00");
                } else {
                    buf.append("000");
                }
            } else if (amt == 3 && value < 100) {
                if (value >= 10) {
                    buf.append('0');
                } else {
                    buf.append("00");
                }
            }
            buf.append(value);
        }

        public String format(Date date) {
            return this.format(date, new StringBuilder()).toString();
        }

        public StringBuilder format(Date date, StringBuilder buf) {
            this.cal.setTime(date);
            int year = this.cal.get(1);
            if (this.cal.get(0) == 0) {
                if (year > 1) {
                    buf.append('-');
                }
                --year;
            }
            this.pad(buf, year, 4);
            buf.append('-');
            this.pad(buf, this.cal.get(2) + 1, 2);
            buf.append('-');
            this.pad(buf, this.cal.get(5), 2);
            buf.append('T');
            this.pad(buf, this.cal.get(11), 2);
            buf.append(':');
            this.pad(buf, this.cal.get(12), 2);
            buf.append(':');
            this.pad(buf, this.cal.get(13), 2);
            buf.append('.');
            this.pad(buf, this.cal.get(14), 3);
            buf.append('Z');
            return buf;
        }
    }

    static enum Mode {
        WMS11,
        WMS13;

    }
}

