/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import java.util.Map;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.animate.FrameCatalogVisitor;

public class FrameCatalog {
    private String parameter;
    private String[] values;
    private GetMapRequest getMapRequest;
    private WebMapService wms;
    private WMS wmsConfiguration;

    private FrameCatalog() {
    }

    public FrameCatalog(GetMapRequest request, WebMapService wms, WMS wmsConfiguration) {
        this();
        this.getMapRequest = request;
        this.wms = wms;
        this.wmsConfiguration = wmsConfiguration;
        Map<String, String> rawKvp = request.getRawKvp();
        String aparam = KvpUtils.caseInsensitiveParam(rawKvp, (String)"aparam", null);
        String avalues = KvpUtils.caseInsensitiveParam(rawKvp, (String)"avalues", null);
        if (aparam == null || aparam.isEmpty() || avalues == null || avalues.isEmpty()) {
            this.dispose();
            throw new RuntimeException("Missing \"animator\" mandatory params \"aparam\" and \"avalues\".");
        }
        this.parameter = aparam;
        this.values = avalues.split("(?<!\\\\)(,)");
        if (this.values.length > this.getWmsConfiguration().getMaxAllowedFrames()) {
            this.dispose();
            throw new RuntimeException("Request too long; reached the maximum allowed number of frames.");
        }
    }

    public String getParameter() {
        return this.parameter;
    }

    public String[] getValues() {
        return this.values;
    }

    public GetMapRequest getGetMapRequest() {
        return this.getMapRequest;
    }

    public WebMapService getWms() {
        return this.wms;
    }

    public WMS getWmsConfiguration() {
        return this.wmsConfiguration;
    }

    void getFrames(FrameCatalogVisitor visitor) {
        for (String value : this.values) {
            visitor.visit(this.getMapRequest, this.wms, this.wmsConfiguration, this.parameter, value);
        }
    }

    void dispose() {
        this.parameter = null;
        this.values = null;
        this.getMapRequest = null;
    }
}

