/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.animate;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.media.jai.RenderedImageList;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.animate.FrameCatalog;
import org.geoserver.wms.animate.FrameCatalogVisitor;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.util.logging.Logging;

public class Animator {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.responses.map.anim");
    public static final String GIF_ANIMATED_FORMAT = "image/gif;subtype=animated";
    WebMapService wms;
    WMS wmsConfiguration;

    public Animator(WebMapService wms, WMS wmsConfiguration) {
        this.wms = wms;
        this.wmsConfiguration = wmsConfiguration;
    }

    public static WebMap produce(GetMapRequest request, WebMapService wms, WMS wmsConfiguration) throws Exception {
        FrameCatalog frameCatalog = Animator.initRequestManager(request, wms, wmsConfiguration);
        if (frameCatalog == null) {
            throw new RuntimeException("Animator initialization error!");
        }
        if (request.getFormat() == null) {
            request.setFormat(GIF_ANIMATED_FORMAT);
        }
        if (frameCatalog.getParameter().equalsIgnoreCase("LAYERS")) {
            List<String> layers0 = Arrays.asList(frameCatalog.getValues()[0].replaceAll("\\\\,", ",").split("\\s*,\\s*"));
            LayerParser parser = new LayerParser(wmsConfiguration);
            List<MapLayerInfo> layers = parser.parseLayerInfos(layers0, request.getRemoteOwsURL(), request.getRemoteOwsType());
            request.setLayers(layers);
        }
        request = DefaultWebMapService.autoSetMissingProperties(request);
        if (frameCatalog.getParameter().equalsIgnoreCase("LAYERS")) {
            Envelope bbox = request.getBbox();
            request.getRawKvp().put("BBOX", bbox.getMinX() + "," + request.getBbox().getMinY() + "," + request.getBbox().getMaxX() + "," + request.getBbox().getMaxY());
            request.getRawKvp().put("WIDTH", String.valueOf(request.getWidth()));
            request.getRawKvp().put("HEIGHT", String.valueOf(request.getHeight()));
        }
        FrameCatalogVisitor visitor = new FrameCatalogVisitor();
        frameCatalog.getFrames(visitor);
        RenderedImageList imageList = visitor.produce(frameCatalog.getWmsConfiguration());
        WebMap wmsResponse = wms.getMap(request);
        return new RenderedImageMap(((RenderedImageMap)wmsResponse).getMapContext(), (RenderedImage)imageList, wmsResponse.getMimeType());
    }

    private static FrameCatalog initRequestManager(GetMapRequest request, WebMapService wms, WMS wmsConfiguration) {
        return new FrameCatalog(request, wms, wmsConfiguration);
    }

    static class LayerParser
    extends GetMapKvpRequestReader {
        public LayerParser(WMS wmsConfiguration) {
            super(wmsConfiguration);
        }

        public List<MapLayerInfo> parseLayerInfos(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) throws Exception {
            List<?> requestedLayerInfos = super.parseLayers(requestedLayerNames, remoteOwsUrl, remoteOwsType);
            ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
            for (Object o : requestedLayerInfos) {
                if (o instanceof LayerInfo) {
                    layers.add(new MapLayerInfo((LayerInfo)o));
                    continue;
                }
                if (o instanceof LayerGroupInfo) {
                    for (LayerInfo l : ((LayerGroupInfo)o).getLayers()) {
                        layers.add(new MapLayerInfo(l));
                    }
                    continue;
                }
                if (!(o instanceof MapLayerInfo)) continue;
                layers.add((MapLayerInfo)o);
            }
            return layers;
        }
    }
}

