/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;
import java.util.Collection;
import org.geoserver.wms.GetMapRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.RendererUtilities;

public class WMSMapContent
extends MapContent {
    private int mapWidth;
    private int mapHeight;
    private Color bgColor = Color.white;
    private boolean transparent;
    private int tileSize = -1;
    private double angle;
    private int buffer;
    private IndexColorModel icm;
    private GetMapRequest request;

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public WMSMapContent() {
    }

    public WMSMapContent(GetMapRequest req) {
        this.request = req;
    }

    public WMSMapContent(Layer[] layers) {
        for (Layer layer : layers) {
            this.addLayer(layer);
        }
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public GetMapRequest getRequest() {
        return this.request;
    }

    public void setRequest(GetMapRequest request) {
        this.request = request;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public IndexColorModel getPalette() {
        return this.icm;
    }

    public void setPalette(IndexColorModel paletteInverter) {
        this.icm = paletteInverter;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double rotation) {
        this.angle = rotation;
    }

    public AffineTransform getRenderingTransform() {
        AffineTransform tx;
        Rectangle paintArea = new Rectangle(0, 0, this.getMapWidth(), this.getMapHeight());
        ReferencedEnvelope dataArea = this.getViewport().getBounds();
        if (this.getAngle() != 0.0) {
            tx = new AffineTransform();
            tx.translate(paintArea.width / 2, paintArea.height / 2);
            tx.rotate(Math.toRadians(this.getAngle()));
            tx.translate(-paintArea.width / 2, -paintArea.height / 2);
            tx.concatenate(RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea));
        } else {
            tx = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)dataArea, (Rectangle)paintArea);
        }
        return tx;
    }

    public ReferencedEnvelope getRenderingArea() {
        ReferencedEnvelope dataArea = this.getViewport().getBounds();
        if (this.getAngle() == 0.0) {
            return dataArea;
        }
        AffineTransform tx = new AffineTransform();
        double offsetX = dataArea.getMinX() + dataArea.getWidth() / 2.0;
        double offsetY = dataArea.getMinY() + dataArea.getHeight() / 2.0;
        tx.translate(offsetX, offsetY);
        tx.rotate(Math.toRadians(this.getAngle()));
        tx.translate(-offsetX, -offsetY);
        Rectangle2D.Double dataAreaShape = new Rectangle2D.Double(dataArea.getMinX(), dataArea.getMinY(), dataArea.getWidth(), dataArea.getHeight());
        Rectangle2D transformedBounds = tx.createTransformedShape(dataAreaShape).getBounds2D();
        return new ReferencedEnvelope(transformedBounds, dataArea.getCoordinateReferenceSystem());
    }

    public String getContactInformation() {
        String contact = (String)this.getUserData().get("contact");
        return contact == null ? "" : contact;
    }

    public void setContactInformation(String contactInformation) {
        this.getUserData().put("contact", contactInformation);
    }

    public String[] getKeywords() {
        Object obj = this.getUserData().get("keywords");
        if (obj == null) {
            return new String[0];
        }
        if (obj instanceof String) {
            String keywords = (String)obj;
            return keywords.split(",");
        }
        if (obj instanceof String[]) {
            String[] keywords = (String[])obj;
            String[] copy = new String[keywords.length];
            System.arraycopy(keywords, 0, copy, 0, keywords.length);
            return copy;
        }
        if (obj instanceof Collection) {
            Collection keywords = (Collection)obj;
            return keywords.toArray(new String[keywords.size()]);
        }
        return new String[0];
    }

    public void setKeywords(String[] keywords) {
        this.getUserData().put("keywords", keywords);
    }

    public String getAbstract() {
        String description = (String)this.getUserData().get("abstract");
        return description == null ? "" : description;
    }

    public void setAbstract(String contextAbstract) {
        this.getUserData().put("abstract", contextAbstract);
    }
}

