/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.springframework.context.ApplicationContext;

public class WMSExtensions {
    public static List<GetMapOutputFormat> findMapProducers(ApplicationContext context) {
        return GeoServerExtensions.extensions(GetMapOutputFormat.class, (ApplicationContext)context);
    }

    public static GetMapOutputFormat findMapProducer(String outputFormat, ApplicationContext applicationContext) {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(applicationContext);
        return WMSExtensions.findMapProducer(outputFormat, producers);
    }

    public static GetMapOutputFormat findMapProducer(String outputFormat, Collection<GetMapOutputFormat> producers) {
        for (GetMapOutputFormat producer : producers) {
            Set<String> producerFormats = producer.getOutputFormatNames();
            TreeSet<String> caseInsensitiveFormats = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveFormats.addAll(producerFormats);
            if (!caseInsensitiveFormats.contains(outputFormat)) continue;
            return producer;
        }
        return null;
    }

    public static List<GetFeatureInfoOutputFormat> findFeatureInfoFormats(ApplicationContext applicationContext) {
        return GeoServerExtensions.extensions(GetFeatureInfoOutputFormat.class, (ApplicationContext)applicationContext);
    }

    public static GetLegendGraphicOutputFormat findLegendGraphicFormat(String outputFormat, ApplicationContext applicationContext) {
        List<GetLegendGraphicOutputFormat> formats = WMSExtensions.findLegendGraphicFormats(applicationContext);
        for (GetLegendGraphicOutputFormat format : formats) {
            if (!format.getContentType().startsWith(outputFormat)) continue;
            return format;
        }
        return null;
    }

    public static List<GetLegendGraphicOutputFormat> findLegendGraphicFormats(ApplicationContext applicationContext) {
        List formats = GeoServerExtensions.extensions(GetLegendGraphicOutputFormat.class, (ApplicationContext)applicationContext);
        return formats;
    }

    public static List<ExtendedCapabilitiesProvider> findExtendedCapabilitiesProviders(ApplicationContext applicationContext) {
        return GeoServerExtensions.extensions(ExtendedCapabilitiesProvider.class, (ApplicationContext)applicationContext);
    }

    public static Collection<RenderedImageMapResponse> findMapResponses(ApplicationContext applicationContext) {
        return GeoServerExtensions.extensions(RenderedImageMapResponse.class, (ApplicationContext)applicationContext);
    }
}

