/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.Filters;
import org.geotools.styling.Style;
import org.geotools.util.Converters;
import org.geotools.util.Range;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WMS
implements ApplicationContextAware {
    public static final Version VERSION_1_1_1 = new Version("1.1.1");
    public static final Version VERSION_1_3_0 = new Version("1.3.0");
    public static final String JPEG_COMPRESSION = "jpegCompression";
    public static final int JPEG_COMPRESSION_DEFAULT = 25;
    public static final String PNG_COMPRESSION = "pngCompression";
    public static final int PNG_COMPRESSION_DEFAULT = 25;
    public static final String MAX_ALLOWED_FRAMES = "maxAllowedFrames";
    public static final int MAX_ALLOWED_FRAMES_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_RENDERING_TIME = "maxAnimatorRenderingTime";
    public static final String MAX_RENDERING_SIZE = "maxRenderingSize";
    public static final String FRAMES_DELAY = "framesDelay";
    public static final int FRAMES_DELAY_DEFAULT = 1000;
    public static final String LOOP_CONTINUOUSLY = "loopContinuously";
    public static final Boolean LOOP_CONTINUOUSLY_DEFAULT = Boolean.FALSE;
    static final Logger LOGGER = Logging.getLogger(WMS.class);
    public static final String WEB_CONTAINER_KEY = "WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    public static String KML_REFLECTOR_MODE = "kmlReflectorMode";
    public static final String KML_REFLECTOR_MODE_REFRESH = "refresh";
    public static final String KML_REFLECTOR_MODE_SUPEROVERLAY = "superoverlay";
    public static final String KML_REFLECTOR_MODE_DOWNLOAD = "download";
    public static final String KML_REFLECTOR_MODE_DEFAULT = "refresh";
    public static final String KML_SUPEROVERLAY_MODE = "kmlSuperoverlayMode";
    public static final String KML_SUPEROVERLAY_MODE_AUTO = "auto";
    public static final String KML_SUPEROVERLAY_MODE_RASTER = "raster";
    public static final String KML_SUPEROVERLAY_MODE_OVERVIEW = "overview";
    public static final String KML_SUPEROVERLAY_MODE_HYBRID = "hybrid";
    public static final String KML_SUPEROVERLAY_MODE_CACHED = "cached";
    public static final String KML_SUPEROVERLAY_MODE_DEFAULT = "auto";
    public static final String KML_KMLATTR = "kmlAttr";
    public static final boolean KML_KMLATTR_DEFAULT = true;
    public static final String KML_KMLPLACEMARK = "kmlPlacemark";
    public static final boolean KML_KMLPLACEMARK_DEFAULT = false;
    public static final String KML_KMSCORE = "kmlKmscore";
    public static final int KML_KMSCORE_DEFAULT = 40;
    private ExecutorService animatorExecutorService;
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private final GeoServer geoserver;
    private ApplicationContext applicationContext;

    public WMS(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    private Catalog getCatalog() {
        return this.geoserver.getCatalog();
    }

    public WMSInfo getServiceInfo() {
        return (WMSInfo)this.geoserver.getService(WMSInfo.class);
    }

    public Style getStyleByName(String styleName) throws IOException {
        StyleInfo styleInfo = this.getCatalog().getStyleByName(styleName);
        return styleInfo == null ? null : styleInfo.getStyle();
    }

    public LayerInfo getLayerByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerGroupName) {
        return this.getCatalog().getLayerGroupByName(layerGroupName);
    }

    public boolean isEnabled() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return serviceInfo.isEnabled();
    }

    public static Version negotiateVersion(String requestedVersion) {
        return WMS.negotiateVersion(requestedVersion != null ? new Version(requestedVersion) : null);
    }

    public static Version negotiateVersion(Version requestedVersion) {
        if (null == requestedVersion) {
            return VERSION_1_3_0;
        }
        if (VERSION_1_1_1.equals((Object)requestedVersion)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.equals((Object)requestedVersion)) {
            return VERSION_1_3_0;
        }
        if (requestedVersion.compareTo(VERSION_1_3_0) < 0) {
            return VERSION_1_1_1;
        }
        return VERSION_1_3_0;
    }

    public String getVersion() {
        WMSInfo serviceInfo = this.getServiceInfo();
        List versions = serviceInfo.getVersions();
        String version = versions.size() > 0 ? ((Version)versions.get(0)).toString() : "1.1.1";
        return version;
    }

    public GeoServer getGeoServer() {
        return this.geoserver;
    }

    public void setAnimatorExecutorService(ExecutorService animatorExecutorService) {
        this.animatorExecutorService = animatorExecutorService;
    }

    public ExecutorService getAnimatorExecutorService() {
        return this.animatorExecutorService;
    }

    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.getServiceInfo().getInterpolation();
    }

    public Boolean getPNGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isPngAcceleration();
    }

    public Boolean getJPEGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isJpegAcceleration();
    }

    private JAIInfo getJaiInfo() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        return global.getJAI();
    }

    public Charset getCharSet() {
        GeoServer geoServer2 = this.getGeoServer();
        String charset = geoServer2.getSettings().getCharset();
        return Charset.forName(charset);
    }

    public String getProxyBaseUrl() {
        GeoServer geoServer = this.getGeoServer();
        return geoServer.getSettings().getProxyBaseUrl();
    }

    public long getUpdateSequence() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getUpdateSequence();
    }

    public int getWatermarkTransparency() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getTransparency();
    }

    public int getWatermarkPosition() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        WatermarkInfo.Position position = watermark.getPosition();
        return position.getCode();
    }

    public boolean isGlobalWatermarking() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.isEnabled();
    }

    public String getGlobalWatermarkingURL() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getURL();
    }

    public FeatureTypeInfo getFeatureTypeInfo(Name name) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo resource = (FeatureTypeInfo)catalog.getResourceByName(name, FeatureTypeInfo.class);
        return resource;
    }

    public CoverageInfo getCoverageInfo(Name name) {
        Catalog catalog = this.getCatalog();
        CoverageInfo resource = (CoverageInfo)catalog.getResourceByName(name, CoverageInfo.class);
        return resource;
    }

    public WMSLayerInfo getWMSLayerInfo(Name name) {
        Catalog catalog = this.getCatalog();
        WMSLayerInfo resource = (WMSLayerInfo)catalog.getResourceByName(name, WMSLayerInfo.class);
        return resource;
    }

    public ResourceInfo getResourceInfo(Name name) {
        Catalog catalog = this.getCatalog();
        ResourceInfo resource = catalog.getResourceByName(name, ResourceInfo.class);
        return resource;
    }

    public List<LayerInfo> getLayers() {
        Catalog catalog = this.getCatalog();
        return catalog.getLayers();
    }

    public String getNamespaceByPrefix(String prefix) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(prefix);
        return namespaceInfo == null ? null : namespaceInfo.getURI();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        Catalog catalog = this.getCatalog();
        List layerGroups = catalog.getLayerGroups();
        return layerGroups;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return true;
    }

    public void setSvgRenderer(String svgRendererHint) {
        WMSInfo serviceInfo = this.getServiceInfo();
        serviceInfo.getMetadata().put("svgRenderer", (Serializable)((Object)svgRendererHint));
        this.getGeoServer().save((ServiceInfo)serviceInfo);
    }

    public String getSvgRenderer() {
        WMSInfo serviceInfo = this.getServiceInfo();
        String svgRendererHint = (String)((Object)serviceInfo.getMetadata().get((Object)"svgRenderer"));
        return svgRendererHint;
    }

    public boolean isSvgAntiAlias() {
        WMSInfo serviceInfo = this.getServiceInfo();
        Boolean svgAntiAlias = (Boolean)Converters.convert((Object)serviceInfo.getMetadata().get((Object)"svgAntiAlias"), Boolean.class);
        return svgAntiAlias == null ? true : svgAntiAlias;
    }

    public int getPngCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), PNG_COMPRESSION, 25);
    }

    public int getJpegCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), JPEG_COMPRESSION, 25);
    }

    public int getMaxAllowedFrames() {
        return this.getMetadataValue(MAX_ALLOWED_FRAMES, Integer.MAX_VALUE, Integer.class);
    }

    public Long getMaxAnimatorRenderingTime() {
        return this.getMetadataValue(MAX_RENDERING_TIME, null, Long.class);
    }

    public Long getMaxRenderingSize() {
        return this.getMetadataValue(MAX_RENDERING_SIZE, null, Long.class);
    }

    public Integer getFramesDelay() {
        return this.getMetadataValue(FRAMES_DELAY, 1000, Integer.class);
    }

    public Boolean getLoopContinuously() {
        return this.getMetadataValue(LOOP_CONTINUOUSLY, LOOP_CONTINUOUSLY_DEFAULT, Boolean.class);
    }

    int getMetadataPercentage(MetadataMap metadata, String key, int defaultValue) {
        Integer parsedValue = (Integer)Converters.convert((Object)metadata.get((Object)key), Integer.class);
        if (parsedValue == null) {
            return defaultValue;
        }
        int value = parsedValue;
        if (value < 0 || value > 100) {
            LOGGER.warning("Invalid percertage value for '" + key + "', it should be between 0 and 100");
            return defaultValue;
        }
        return value;
    }

    <T> T getMetadataValue(String key, T defaultValue, Class<T> clazz) {
        if (this.getServiceInfo() == null) {
            return defaultValue;
        }
        MetadataMap metadata = this.getServiceInfo().getMetadata();
        Object parsedValue = Converters.convert((Object)metadata.get((Object)key), clazz);
        if (parsedValue == null) {
            return defaultValue;
        }
        return (T)parsedValue;
    }

    public int getNumDecimals() {
        return this.getGeoServer().getSettings().getNumDecimals();
    }

    public String getNameSpacePrefix(String nsUri) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
        return ns == null ? null : ns.getPrefix();
    }

    public int getMaxBuffer() {
        return this.getServiceInfo().getMaxBuffer();
    }

    public int getMaxRequestMemory() {
        return this.getServiceInfo().getMaxRequestMemory();
    }

    public int getMaxRenderingTime() {
        return this.getServiceInfo().getMaxRenderingTime();
    }

    public int getMaxRenderingErrors() {
        return this.getServiceInfo().getMaxRenderingErrors();
    }

    public String getKmlReflectorMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_REFLECTOR_MODE));
        return value != null ? value : "refresh";
    }

    public String getKmlSuperoverlayMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_SUPEROVERLAY_MODE));
        return value != null ? value : "auto";
    }

    public boolean getKmlKmAttr() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLATTR), Boolean.class);
        return kmAttr == null ? true : kmAttr;
    }

    public boolean getKmlPlacemark() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLPLACEMARK), Boolean.class);
        return kmAttr == null ? false : kmAttr;
    }

    public int getKmScore() {
        return this.getMetadataPercentage(this.getServiceInfo().getMetadata(), KML_KMSCORE, 40);
    }

    public Collection<GetMapOutputFormat> getAvailableMapFormats() {
        return WMSExtensions.findMapProducers(this.applicationContext);
    }

    public Set<String> getAvailableMapFormatNames() {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(this.applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapOutputFormat producer : producers) {
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public Set<String> getAvailableLegendGraphicsFormats() {
        List<GetLegendGraphicOutputFormat> formats = WMSExtensions.findLegendGraphicFormats(this.applicationContext);
        HashSet<String> mimeTypes = new HashSet<String>();
        for (GetLegendGraphicOutputFormat format : formats) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<ExtendedCapabilitiesProvider> getAvailableExtendedCapabilitiesProviders() {
        return WMSExtensions.findExtendedCapabilitiesProviders(this.applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public GetFeatureInfoOutputFormat getFeatureInfoOutputFormat(String requestFormat) {
        List<GetFeatureInfoOutputFormat> outputFormats = WMSExtensions.findFeatureInfoFormats(this.applicationContext);
        for (GetFeatureInfoOutputFormat format : outputFormats) {
            if (!format.canProduce(requestFormat)) continue;
            return format;
        }
        return null;
    }

    public List<String> getAvailableFeatureInfoFormats() {
        List<GetFeatureInfoOutputFormat> outputFormats = WMSExtensions.findFeatureInfoFormats(this.applicationContext);
        ArrayList<String> mimeTypes = new ArrayList<String>(outputFormats.size());
        for (GetFeatureInfoOutputFormat format : outputFormats) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public GetMapOutputFormat getMapOutputFormat(String mimeType) {
        GetMapOutputFormat outputFormat = WMSExtensions.findMapProducer(mimeType, this.applicationContext);
        return outputFormat;
    }

    public GetLegendGraphicOutputFormat getLegendGraphicOutputFormat(String outputFormat) {
        GetLegendGraphicOutputFormat format = WMSExtensions.findLegendGraphicFormat(outputFormat, this.applicationContext);
        return format;
    }

    public static Version version(String version) {
        return WMS.version(version, false);
    }

    public static Version version(String version, boolean exact) {
        if (version == null || 0 == version.trim().length()) {
            return null;
        }
        if (VERSION_1_1_1.toString().equals(version)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.toString().equals(version)) {
            return VERSION_1_3_0;
        }
        return exact ? null : new Version(version);
    }

    public static String toInternalSRS(String srs, Version version) {
        if (VERSION_1_3_0.equals((Object)version) && srs != null && srs.toUpperCase().startsWith("EPSG:")) {
            srs = srs.toUpperCase().replace("EPSG:", "urn:x-ogc:def:crs:EPSG:");
        }
        return srs;
    }

    public boolean isQueryable(LayerInfo layer) {
        try {
            if (layer.getResource() instanceof WMSLayerInfo) {
                WMSLayerInfo info = (WMSLayerInfo)layer.getResource();
                Layer wl = info.getWMSLayer(null);
                if (!wl.isQueryable()) {
                    return false;
                }
                WMSCapabilities caps = info.getStore().getWebMapServer(null).getCapabilities();
                if (!caps.getRequest().getGetFeatureInfo().getFormats().contains("application/vnd.ogc.gml")) {
                    return false;
                }
            }
            return layer.isQueryable();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to determin if the layer is queryable, assuming it's not", e);
            return false;
        }
    }

    public Integer getCascadedHopCount(LayerInfo layer) {
        if (!(layer.getResource() instanceof WMSLayerInfo)) {
            return null;
        }
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layer.getResource();
        int cascaded = 1;
        try {
            Layer wmsLayer = wmsLayerInfo.getWMSLayer(null);
            cascaded = 1 + wmsLayer.getCascaded();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Unable to determina WMSLayer cascaded hop count", e);
        }
        return cascaded;
    }

    public boolean isQueryable(LayerGroupInfo layerGroup) {
        for (LayerInfo layer : layerGroup.getLayers()) {
            if (this.isQueryable(layer)) continue;
            return false;
        }
        return true;
    }

    public GeneralParameterValue[] getWMSReadParameters(GetMapRequest request, MapLayerInfo mapLayerInfo, Filter layerFilter, List<Object> times, List<Object> elevations, AbstractGridCoverage2DReader reader, boolean readGeom) throws IOException {
        DimensionInfo elevationInfo;
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        CoverageInfo coverage = mapLayerInfo.getCoverage();
        MetadataMap metadata = coverage.getMetadata();
        GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)coverage.getParameters(), (boolean)readGeom);
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
        List parameterDescriptors = readParametersDescriptor.getDescriptor().descriptors();
        if (timeInfo != null && timeInfo.isEnabled()) {
            ArrayList<Object> fixedTimes = new ArrayList<Object>(times);
            for (int i = 0; i < fixedTimes.size(); ++i) {
                if (fixedTimes.get(i) != null) continue;
                fixedTimes.set(i, this.getCurrentTime(coverage, dimensions));
            }
            readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, fixedTimes, (String[])new String[]{"TIME", "Time"});
        }
        if ((elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class)) != null && elevationInfo.isEnabled()) {
            ArrayList<Object> fixedElevations = new ArrayList<Object>(elevations);
            for (int i = 0; i < fixedElevations.size(); ++i) {
                if (fixedElevations.get(i) != null) continue;
                fixedElevations.set(i, this.getDefaultElevation(coverage, dimensions));
            }
            readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, fixedElevations, (String[])new String[]{"ELEVATION", "Elevation"});
        }
        if (layerFilter != null) {
            readParameters = CoverageUtils.mergeParameter((List)parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)layerFilter, (String[])new String[]{"FILTER", "Filter"});
        }
        return readParameters;
    }

    public Collection<RenderedImageMapResponse> getAvailableMapResponses() {
        return WMSExtensions.findMapResponses(this.applicationContext);
    }

    public TreeSet<Date> getFeatureTypeTimes(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo time = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.getPrefixedName() + " does not have time support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, time);
        TreeSet<Date> result = new TreeSet<Date>();
        if (time.getPresentation() == DimensionPresentation.LIST) {
            UniqueVisitor visitor = new UniqueVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)visitor, null);
            Set values = visitor.getUnique();
            if (values.size() <= 0) {
                result = null;
            } else {
                values.remove(null);
                result.addAll(values);
            }
        } else {
            MinVisitor min = new MinVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)min, null);
            CalcResult minResult = min.getResult();
            if (minResult != CalcResult.NULL_RESULT) {
                result.add((Date)min.getMin());
                MaxVisitor max = new MaxVisitor(time.getAttribute());
                collection.accepts((FeatureVisitor)max, null);
                result.add((Date)max.getMax());
            }
        }
        return result;
    }

    public TreeSet<Double> getFeatureTypeElevations(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo elevation = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !elevation.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.getPrefixedName() + " does not have elevation support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, elevation);
        TreeSet<Double> result = new TreeSet<Double>();
        if (elevation.getPresentation() == DimensionPresentation.LIST || elevation.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL && elevation.getResolution() == null) {
            UniqueVisitor visitor = new UniqueVisitor(elevation.getAttribute());
            collection.accepts((FeatureVisitor)visitor, null);
            Set values = visitor.getUnique();
            if (values.size() <= 0) {
                result = null;
            } else {
                for (Object value : values) {
                    result.add(((Number)value).doubleValue());
                }
            }
        } else {
            MinVisitor min = new MinVisitor(elevation.getAttribute());
            collection.accepts((FeatureVisitor)min, null);
            CalcResult calcResult = min.getResult();
            if (calcResult != CalcResult.NULL_RESULT) {
                result.add(((Number)((Object)min.getMin())).doubleValue());
                MaxVisitor max = new MaxVisitor(elevation.getAttribute());
                collection.accepts((FeatureVisitor)max, null);
                result.add(((Number)((Object)max.getMax())).doubleValue());
            }
        }
        return result;
    }

    public Date getCurrentTime(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo time = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.getPrefixedName() + " does not have time support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, time);
        MaxVisitor max = new MaxVisitor(time.getAttribute());
        collection.accepts((FeatureVisitor)max, null);
        return (Date)max.getMax();
    }

    Date getCurrentTime(CoverageInfo coverage, ReaderDimensionsAccessor dimensions) throws IOException {
        DimensionInfo time = (DimensionInfo)coverage.getMetadata().get("time", DimensionInfo.class);
        String name = coverage.getPrefixedName();
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + name + " does not have time support enabled");
        }
        return dimensions.getMaxTime();
    }

    Double getDefaultElevation(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo elevation = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !elevation.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.getPrefixedName() + " does not have time support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, elevation);
        MinVisitor min = new MinVisitor(elevation.getAttribute());
        collection.accepts((FeatureVisitor)min, null);
        if (min.getMin() == null) {
            return null;
        }
        return ((Number)((Object)min.getMin())).doubleValue();
    }

    Double getDefaultElevation(CoverageInfo coverage, ReaderDimensionsAccessor dimensions) throws IOException {
        DimensionInfo elevation = (DimensionInfo)coverage.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !coverage.isEnabled()) {
            throw new ServiceException("Layer " + coverage.getPrefixedName() + " does not have time support enabled");
        }
        return dimensions.getMinElevation();
    }

    FeatureCollection getDimensionCollection(FeatureTypeInfo typeInfo, DimensionInfo dimension) throws IOException {
        FeatureSource source = null;
        try {
            source = typeInfo.getFeatureSource(null, GeoTools.getDefaultHints());
        }
        catch (IOException e) {
            throw new ServiceException("Could not get the feauture source to list time info for layer " + typeInfo.getPrefixedName(), (Throwable)e);
        }
        Query dimQuery = new Query(source.getSchema().getName().getLocalPart());
        dimQuery.setPropertyNames(Arrays.asList(dimension.getAttribute()));
        return source.getFeatures(dimQuery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Filter buildDimensionFilter(Object value, PropertyName attribute, PropertyName endAttribute) {
        if (value instanceof Range) {
            Range range = (Range)value;
            if (endAttribute == null) {
                return ff.between((Expression)attribute, (Expression)ff.literal((Object)range.getMinValue()), (Expression)ff.literal((Object)range.getMaxValue()));
            }
            Literal qlower = ff.literal((Object)range.getMinValue());
            Literal qupper = ff.literal((Object)range.getMaxValue());
            PropertyIsBetween lower = ff.between((Expression)attribute, (Expression)qlower, (Expression)qupper);
            PropertyIsBetween upper = ff.between((Expression)endAttribute, (Expression)qlower, (Expression)qupper);
            return ff.or((Filter)lower, (Filter)upper);
        }
        if (endAttribute == null) {
            return ff.equal((Expression)attribute, (Expression)ff.literal(value), true);
        }
        PropertyIsGreaterThanOrEqualTo lower = ff.greaterOrEqual((Expression)ff.literal(value), (Expression)attribute);
        PropertyIsLessThanOrEqualTo upper = ff.lessOrEqual((Expression)ff.literal(value), (Expression)endAttribute);
        return ff.and((Filter)lower, (Filter)upper);
    }

    public Filter getTimeElevationToFilter(List<Object> times, List<Object> elevations, FeatureTypeInfo typeInfo) throws IOException {
        PropertyName endAttribute;
        PropertyName attribute;
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        DimensionInfo elevationInfo = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        Or result = null;
        if (timeInfo != null && timeInfo.isEnabled() && times != null) {
            ArrayList<Filter> timeFilters = new ArrayList<Filter>();
            attribute = ff.property(timeInfo.getAttribute());
            endAttribute = timeInfo.getEndAttribute() == null ? null : ff.property(timeInfo.getEndAttribute());
            for (Object datetime : times) {
                if (datetime == null) {
                    datetime = this.getCurrentTime(typeInfo);
                }
                timeFilters.add(this.buildDimensionFilter(datetime, attribute, endAttribute));
            }
            int sizeTime = timeFilters.size();
            if (sizeTime > 1) {
                result = ff.or(timeFilters);
            } else if (sizeTime == 1) {
                result = (Filter)timeFilters.get(0);
            }
        }
        if (elevationInfo != null && elevationInfo.isEnabled() && elevations != null) {
            ArrayList<Filter> elevationFilters = new ArrayList<Filter>();
            attribute = ff.property(elevationInfo.getAttribute());
            endAttribute = elevationInfo.getEndAttribute() == null ? null : ff.property(elevationInfo.getEndAttribute());
            for (Object elevation : elevations) {
                if (elevation == null) {
                    elevation = this.getDefaultElevation(typeInfo);
                }
                elevationFilters.add(this.buildDimensionFilter(elevation, attribute, endAttribute));
            }
            int size = elevationFilters.size();
            Or summary = null;
            if (size > 1) {
                summary = ff.or(elevationFilters);
            } else if (size == 1) {
                summary = (Filter)elevationFilters.get(0);
            }
            if (summary != null) {
                result = Filters.and((FilterFactory)ff, (Filter)result, (Filter)summary);
            }
        }
        return result;
    }

    public static WMS get() {
        return (WMS)GeoServerExtensions.bean(WMS.class);
    }
}

