/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class MapLayerInfo {
    public static int TYPE_VECTOR = LayerInfo.Type.VECTOR.getCode();
    public static int TYPE_RASTER = LayerInfo.Type.RASTER.getCode();
    public static int TYPE_REMOTE_VECTOR = LayerInfo.Type.REMOTE.getCode();
    public static int TYPE_WMS = LayerInfo.Type.WMS.getCode();
    private final SimpleFeatureSource remoteFeatureSource;
    private final int type;
    private String name;
    private final String label;
    private final String description;
    private final LayerInfo layerInfo;
    private Style style;
    private FeatureTypeConstraint[] layerFeatureConstraints;

    public MapLayerInfo(SimpleFeatureSource remoteSource) {
        this.remoteFeatureSource = remoteSource;
        this.layerInfo = null;
        this.label = this.name = ((SimpleFeatureType)this.remoteFeatureSource.getSchema()).getTypeName();
        this.description = "Remote WFS";
        this.type = TYPE_REMOTE_VECTOR;
    }

    public MapLayerInfo(LayerInfo layerInfo) {
        this.layerInfo = layerInfo;
        this.remoteFeatureSource = null;
        ResourceInfo resource = layerInfo.getResource();
        this.name = resource.getPrefixedName();
        this.label = resource.getTitle();
        this.description = resource.getAbstract();
        this.type = layerInfo.getType().getCode();
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public ReferencedEnvelope getBoundingBox() throws Exception {
        if (this.layerInfo != null) {
            ResourceInfo resource = this.layerInfo.getResource();
            ReferencedEnvelope bbox = resource.boundingBox();
            return bbox;
        }
        if (this.type == TYPE_REMOTE_VECTOR) {
            return this.remoteFeatureSource.getBounds();
        }
        return null;
    }

    public ReferencedEnvelope getLatLongBoundingBox() throws IOException {
        if (this.layerInfo != null) {
            ResourceInfo resource = this.layerInfo.getResource();
            return resource.getLatLonBoundingBox();
        }
        throw new UnsupportedOperationException("getLatLongBoundingBox not implemented for remote sources");
    }

    public CoverageInfo getCoverage() {
        return (CoverageInfo)this.layerInfo.getResource();
    }

    public String getDescription() {
        return this.description;
    }

    public FeatureTypeInfo getFeature() {
        return (FeatureTypeInfo)this.layerInfo.getResource();
    }

    public ResourceInfo getResource() {
        return this.layerInfo.getResource();
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public Style getDefaultStyle() {
        if (this.layerInfo != null) {
            try {
                return this.layerInfo.getDefaultStyle().getStyle();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public SimpleFeatureSource getRemoteFeatureSource() {
        return this.remoteFeatureSource;
    }

    public String getSRS() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getSRS();
        }
        return null;
    }

    public List<String> getOtherStyleNames() {
        if (this.layerInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<String> styleNames = new ArrayList<String>();
        for (StyleInfo si : this.layerInfo.getStyles()) {
            styleNames.add(si.getName());
        }
        return styleNames;
    }

    public boolean isCachingEnabled() {
        if (this.layerInfo == null) {
            return false;
        }
        if (this.type == TYPE_REMOTE_VECTOR) {
            return false;
        }
        ResourceInfo resource = this.layerInfo.getResource();
        Boolean cachingEnabled = (Boolean)resource.getMetadata().get("cachingEnabled", Boolean.class);
        return cachingEnabled == null ? false : cachingEnabled;
    }

    public int getCacheMaxAge() {
        if (this.layerInfo == null) {
            return 0;
        }
        ResourceInfo resource = this.layerInfo.getResource();
        Integer val = (Integer)resource.getMetadata().get("cacheAgeMax", Integer.class);
        return val == null ? 0 : val;
    }

    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(boolean skipReproject) throws IOException {
        if (this.type != TYPE_VECTOR) {
            throw new IllegalArgumentException("Layer type is not vector");
        }
        if (!this.layerInfo.enabled()) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        FeatureTypeInfo resource = (FeatureTypeInfo)this.layerInfo.getResource();
        if (resource.getStore() == null || resource.getStore().getDataStore(null) == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        Hints hints = new Hints((RenderingHints.Key)ResourcePool.REPROJECT, (Object)(!skipReproject ? 1 : 0));
        return resource.getFeatureSource(null, hints);
    }

    public GridCoverageReader getCoverageReader() throws IOException {
        if (this.type != TYPE_RASTER) {
            throw new IllegalArgumentException("Layer type is not raster");
        }
        CoverageInfo resource = (CoverageInfo)this.layerInfo.getResource();
        return resource.getGridCoverageReader(null, GeoTools.getDefaultHints());
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.layerInfo != null) {
            return this.layerInfo.getResource().getCRS();
        }
        if (this.remoteFeatureSource != null) {
            SimpleFeatureType schema = (SimpleFeatureType)this.remoteFeatureSource.getSchema();
            return schema.getCoordinateReferenceSystem();
        }
        throw new IllegalStateException();
    }

    public static String getRegionateAttribute(FeatureTypeInfo layerInfo) {
        return (String)layerInfo.getMetadata().get("kml.regionateAttribute", String.class);
    }

    public void setLayerFeatureConstraints(FeatureTypeConstraint[] layerFeatureConstraints) {
        this.layerFeatureConstraints = layerFeatureConstraints;
    }

    public FeatureTypeConstraint[] getLayerFeatureConstraints() {
        return this.layerFeatureConstraints;
    }

    public LayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapLayerInfo other = (MapLayerInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }
}

