/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.kml.KMLReflector;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.sld.GetStyles;
import org.geoserver.sld.GetStylesRequest;
import org.geoserver.wms.DescribeLayer;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.GetCapabilities;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.GetFeatureInfo;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.animate.Animator;
import org.geoserver.wms.describelayer.DescribeLayerTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWebMapService
implements WebMapService,
ApplicationContextAware,
DisposableBean {
    public static String FORMAT = "image/png";
    public static List<Style> STYLES = Collections.emptyList();
    public static int MAX_SIDE = 512;
    public static int MIN_OL_HEIGHT = 330;
    public static String SRS = "EPSG:4326";
    public static Boolean TRANSPARENT = Boolean.TRUE;
    public static ExecutorService RENDERING_POOL;
    public static ReferencedEnvelope BBOX;
    private final WMS wms;
    private static Boolean OPTIMIZE_LINE_WIDTH;
    private static Boolean USE_SHAPEFILE_RENDERER;
    private static boolean BYPASS_DIRECT;
    private static Integer MAX_FILTER_RULES;
    private static Boolean ENABLE_MAP_WRAPPING;
    private static Boolean USE_GLOBAL_RENDERING_POOL;
    private GetCapabilities getCapabilities;
    private DescribeLayer describeLayer;
    private GetMap getMap;
    private GetFeatureInfo getFeatureInfo;
    private GetStyles getStyles;
    private GetLegendGraphic getLegendGraphic;

    public DefaultWebMapService(WMS wms) {
        this.wms = wms;
    }

    @Override
    public WMSInfo getServiceInfo() {
        return this.wms.getServiceInfo();
    }

    public void setGetCapabilities(GetCapabilities getCapabilities) {
        this.getCapabilities = getCapabilities;
    }

    public void setDescribeLayer(DescribeLayer describeLayer) {
        this.describeLayer = describeLayer;
    }

    public void setGetMap(GetMap getMap) {
        this.getMap = getMap;
    }

    public void setGetFeatureInfo(GetFeatureInfo getFeatureInfo) {
        this.getFeatureInfo = getFeatureInfo;
    }

    public void setGetStyles(GetStyles getStyles) {
        this.getStyles = getStyles;
    }

    public void setGetLegendGraphic(GetLegendGraphic getLegendGraphic) {
        this.getLegendGraphic = getLegendGraphic;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        String enabled;
        if (OPTIMIZE_LINE_WIDTH == null) {
            enabled = GeoServerExtensions.getProperty((String)"OPTIMIZE_LINE_WIDTH", (ApplicationContext)context);
            OPTIMIZE_LINE_WIDTH = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
        if (USE_SHAPEFILE_RENDERER == null) {
            enabled = GeoServerExtensions.getProperty((String)"USE_SHAPEFILE_RENDERER", (ApplicationContext)context);
            USE_SHAPEFILE_RENDERER = enabled == null ? Boolean.valueOf(false) : Boolean.valueOf(enabled);
        }
        if (MAX_FILTER_RULES == null) {
            String rules = GeoServerExtensions.getProperty((String)"MAX_FILTER_RULES", (ApplicationContext)context);
            MAX_FILTER_RULES = rules == null ? Integer.valueOf(20) : Integer.valueOf(rules);
        }
        if (ENABLE_MAP_WRAPPING == null) {
            String wrapping = GeoServerExtensions.getProperty((String)"ENABLE_MAP_WRAPPING", (ApplicationContext)context);
            ENABLE_MAP_WRAPPING = wrapping == null ? Boolean.valueOf(true) : Boolean.valueOf(wrapping);
        }
        if (USE_GLOBAL_RENDERING_POOL == null) {
            String usePool = GeoServerExtensions.getProperty((String)"USE_GLOBAL_RENDERING_POOL", (ApplicationContext)context);
            USE_GLOBAL_RENDERING_POOL = usePool == null ? Boolean.valueOf(true) : Boolean.valueOf(usePool);
        }
    }

    public static boolean isLineWidthOptimizationEnabled() {
        return OPTIMIZE_LINE_WIDTH;
    }

    public static boolean isContinuousMapWrappingEnabled() {
        return ENABLE_MAP_WRAPPING;
    }

    public static boolean useShapefileRenderer() {
        return USE_SHAPEFILE_RENDERER;
    }

    public static int getMaxFilterRules() {
        return MAX_FILTER_RULES;
    }

    public static boolean isDirectRasterPathEnabled() {
        return !BYPASS_DIRECT;
    }

    public TransformerBase getCapabilities(GetCapabilitiesRequest request) {
        if (null == this.getCapabilities) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getCapabilities.run(request);
    }

    public TransformerBase capabilities(GetCapabilitiesRequest request) {
        return this.getCapabilities(request);
    }

    public DescribeLayerTransformer describeLayer(DescribeLayerRequest request) {
        if (null == this.describeLayer) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.describeLayer.run(request);
    }

    @Override
    public WebMap getMap(GetMapRequest request) {
        if (null == this.getMap) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getMap.run(request);
    }

    @Override
    public WebMap map(GetMapRequest request) {
        return this.getMap(request);
    }

    @Override
    public FeatureCollectionType getFeatureInfo(GetFeatureInfoRequest request) {
        if (null == this.getFeatureInfo) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getFeatureInfo.run(request);
    }

    @Override
    public Object getLegendGraphic(GetLegendGraphicRequest request) {
        if (null == this.getLegendGraphic) {
            throw new UnsupportedOperationException("Operation not properly configured, make sure the operation bean has been set");
        }
        return this.getLegendGraphic.run(request);
    }

    @Override
    public WebMap kml(GetMapRequest getMap) {
        try {
            return KMLReflector.doWms(getMap, this, this.wms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WebMap animate(GetMapRequest getMap) {
        try {
            return Animator.produce(getMap, this, this.wms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WebMap reflect(GetMapRequest request) {
        return this.getMapReflect(request);
    }

    @Override
    public StyledLayerDescriptor getStyles(GetStylesRequest request) {
        return this.getStyles.run(request);
    }

    @Override
    public WebMap getMapReflect(GetMapRequest request) {
        GetMapRequest getMap = DefaultWebMapService.autoSetMissingProperties(request);
        return this.getMap(getMap);
    }

    public static GetMapRequest autoSetMissingProperties(GetMapRequest getMap) {
        if (getMap.getFormat() == null) {
            getMap.setFormat(FORMAT);
        }
        if (getMap.getStyles() == null || getMap.getStyles().isEmpty()) {
            if (getMap.getLayers() != null && getMap.getLayers().size() > 0) {
                ArrayList<Style> styles = new ArrayList<Style>(getMap.getLayers().size());
                for (int i = 0; i < getMap.getLayers().size(); ++i) {
                    styles.add(getMap.getLayers().get(i).getDefaultStyle());
                }
                getMap.setStyles(styles);
            } else {
                getMap.setStyles(STYLES);
            }
        }
        DefaultWebMapService.autoSetBoundsAndSize(getMap);
        return getMap;
    }

    public static void autoSetBoundsAndSize(GetMapRequest getMap) {
        CoordinateReferenceSystem reqCRS;
        List<MapLayerInfo> layers = getMap.getLayers();
        String reqSRS = getMap.getSRS();
        boolean useNativeBounds = true;
        if (reqSRS == null) {
            reqSRS = DefaultWebMapService.guessCommonSRS(layers);
            DefaultWebMapService.forceSRS(getMap, reqSRS);
        }
        for (int i = 0; useNativeBounds && i < layers.size(); ++i) {
            String layerSRS;
            useNativeBounds = layers.get(i) != null ? reqSRS.equalsIgnoreCase(layerSRS = layers.get(i).getSRS()) && layers.get(i).getResource().getNativeBoundingBox() != null : false;
        }
        try {
            reqCRS = CRS.decode((String)reqSRS);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        Envelope aggregateBbox = getMap.getBbox();
        boolean specifiedBbox = true;
        if (aggregateBbox == null) {
            specifiedBbox = false;
            for (int i = 0; i < layers.size(); ++i) {
                ReferencedEnvelope curbbox;
                block34: {
                    MapLayerInfo layerInfo = layers.get(i);
                    try {
                        curbbox = layerInfo.getLatLongBoundingBox();
                        if (!useNativeBounds) break block34;
                        ReferencedEnvelope nativeBbox = layerInfo.getBoundingBox();
                        if (nativeBbox == null) {
                            try {
                                CoordinateReferenceSystem nativeCrs = layerInfo.getCoordinateReferenceSystem();
                                nativeBbox = curbbox.transform(nativeCrs, true);
                            }
                            catch (Exception e) {
                                throw new ServiceException("Best effort native bbox computation failed", (Throwable)e);
                            }
                        }
                        curbbox = nativeBbox;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (aggregateBbox != null) {
                    aggregateBbox.expandToInclude((Envelope)curbbox);
                    continue;
                }
                aggregateBbox = curbbox;
            }
            ReferencedEnvelope ref = null;
            if (!useNativeBounds && !reqSRS.equalsIgnoreCase(SRS)) {
                try {
                    ref = new ReferencedEnvelope(aggregateBbox, CRS.decode((String)"EPSG:4326"));
                    aggregateBbox = ref.transform(reqCRS, true);
                }
                catch (ProjectionException pe) {
                    ref.expandBy(-1.0 * ref.getWidth() / 50.0, -1.0 * ref.getHeight() / 50.0);
                    try {
                        aggregateBbox = ref.transform(reqCRS, true);
                    }
                    catch (FactoryException e) {
                        e.printStackTrace();
                    }
                    catch (TransformException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchAuthorityCodeException e) {
                    e.printStackTrace();
                }
                catch (TransformException e) {
                    e.printStackTrace();
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                }
            }
        }
        if (aggregateBbox == null) {
            DefaultWebMapService.forceSRS(getMap, SRS);
            aggregateBbox = BBOX;
        }
        double bbheight = aggregateBbox.getHeight();
        double bbwidth = aggregateBbox.getWidth();
        double bbratio = bbwidth / bbheight;
        double mheight = getMap.getHeight();
        double mwidth = getMap.getWidth();
        if (!(mheight > 0.5 && mwidth > 0.5 && specifiedBbox)) {
            if (mheight > 0.5 && mwidth > 0.5) {
                double mratio = mwidth / mheight;
                if (bbratio > mratio) {
                    double diff = (bbwidth / mratio - bbheight) / 2.0;
                    aggregateBbox.expandBy(0.0, diff);
                } else {
                    double diff = (bbheight * mratio - bbwidth) / 2.0;
                    aggregateBbox.expandBy(diff, 0.0);
                }
                DefaultWebMapService.adjustBounds(reqSRS, aggregateBbox);
            } else if (mheight > 0.5) {
                mwidth = bbratio * mheight;
            } else if (mwidth > 0.5) {
                mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
            } else {
                if (bbratio > 1.0) {
                    mwidth = MAX_SIDE;
                    mheight = mwidth / bbratio >= 1.0 ? mwidth / bbratio : 1.0;
                } else {
                    mheight = MAX_SIDE;
                    double d = mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
                if (mheight < (double)MIN_OL_HEIGHT && ("application/openlayers".equalsIgnoreCase(getMap.getFormat()) || "openlayers".equalsIgnoreCase(getMap.getFormat()))) {
                    mheight = MIN_OL_HEIGHT;
                    mwidth = mheight * bbratio >= 1.0 ? mheight * bbratio : 1.0;
                }
            }
            getMap.setBbox(aggregateBbox);
            getMap.setWidth((int)mwidth);
            getMap.setHeight((int)mheight);
        }
    }

    private static String guessCommonSRS(List<MapLayerInfo> layers) {
        String SRS = null;
        for (MapLayerInfo layer : layers) {
            String layerSRS = layer.getSRS();
            if (SRS == null) {
                SRS = layerSRS.toUpperCase();
                continue;
            }
            if (SRS.equals(layerSRS)) continue;
            return DefaultWebMapService.SRS;
        }
        if (SRS == null) {
            return DefaultWebMapService.SRS;
        }
        return SRS;
    }

    private static void forceSRS(GetMapRequest getMap, String srs) {
        getMap.setSRS(srs);
        try {
            getMap.setCrs(CRS.decode((String)srs));
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    private static Envelope adjustBounds(String reqSRS, Envelope bbox) {
        if (reqSRS.equalsIgnoreCase("EPSG:4326")) {
            bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
            Envelope maxEnv = new Envelope(-180.0, -90.0, 180.0, 90.0);
            return bbox.intersection(maxEnv);
        }
        if (reqSRS.equalsIgnoreCase("EPSG:900913")) {
            bbox.expandBy(bbox.getWidth() / 100.0, bbox.getHeight() / 100.0);
            Envelope maxEnv = new Envelope(-2.003750833E7, -2.003750833E7, 2.003750833E7, 2.003750833E7);
            return bbox.intersection(maxEnv);
        }
        return bbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getRenderingPool() {
        if (!USE_GLOBAL_RENDERING_POOL.booleanValue() || RENDERING_POOL != null) return RENDERING_POOL;
        Class<DefaultWebMapService> clazz = DefaultWebMapService.class;
        synchronized (DefaultWebMapService.class) {
            if (RENDERING_POOL != null) return RENDERING_POOL;
            RENDERING_POOL = Executors.newCachedThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return RENDERING_POOL;
        }
    }

    public void destroy() throws Exception {
        if (RENDERING_POOL != null) {
            RENDERING_POOL.shutdown();
            RENDERING_POOL.awaitTermination(10L, TimeUnit.SECONDS);
            RENDERING_POOL = null;
        }
    }

    static {
        BBOX = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        OPTIMIZE_LINE_WIDTH = null;
        USE_SHAPEFILE_RENDERER = null;
        BYPASS_DIRECT = Boolean.getBoolean("org.geoserver.render.raster.direct.disable");
        MAX_FILTER_RULES = null;
        ENABLE_MAP_WRAPPING = null;
        USE_GLOBAL_RENDERING_POOL = null;
    }
}

