/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.sld;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.sld.PutStylesRequest;
import org.geoserver.sld.SldException;
import org.geoserver.wms.WMS;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;

public class PutStylesKvpReader
extends KvpRequestReader {
    private WMS config;

    public PutStylesKvpReader(Map kvpPairs, WMS service) {
        super(kvpPairs, (ServiceInfo)service.getServiceInfo());
        this.config = service;
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        PutStylesRequest request = new PutStylesRequest((WMS)this.serviceConfig);
        request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        request.setVersion(version);
        this.parseMandatoryParameters(request);
        this.parseOptionalParameters(request);
        return request;
    }

    public void parseMandatoryParameters(PutStylesRequest request) throws SldException {
        String req = this.getValue("REQUEST");
        if (req != null && !req.equals("") && !req.equalsIgnoreCase("PutStyles")) {
            throw new SldException("Expecting 'request=PutStyles'");
        }
        String mode = this.getValue("MODE");
        if (mode != null && !mode.equals("")) {
            if (mode.equalsIgnoreCase("InsertAndReplace") || mode.equalsIgnoreCase("ReplaceAll")) {
                request.setMode(mode);
            } else {
                throw new SldException("Parameter must be 'InsertAndReplace' or 'ReplaceAll'.");
            }
        }
    }

    public void parseOptionalParameters(PutStylesRequest request) {
        String sld_body;
        String sld = this.getValue("SLD");
        if (sld != null && !sld.equals("")) {
            request.setSLD(sld);
        }
        if ((sld_body = this.getValue("SLD_BODY")) != null && !sld_body.equals("")) {
            request.setSldBody(sld_body);
        }
    }

    protected String getRequestVersion() {
        String version = this.getValue("VERSION");
        if (version == null) {
            version = this.getValue("WMTVER");
        }
        if (version == null) {
            version = this.config.getVersion();
        }
        return version;
    }
}

