/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.sld;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geoserver.platform.ServiceException;
import org.geoserver.sld.PutStylesKvpReader;
import org.geoserver.sld.PutStylesRequest;
import org.geoserver.sld.SldException;
import org.geoserver.wms.WMS;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PutStyles
extends AbstractService {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.sld.servlets");
    public final String success_mime_type = "application/vnd.ogc.success+xml";
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();

    public PutStyles(WMS config) {
        super("WMS", "PutStyles", (ServiceInfo)config.getServiceInfo());
    }

    protected boolean isServiceEnabled(HttpServletRequest req) {
        return true;
    }

    protected Response getResponseHandler() {
        throw new UnsupportedOperationException("not implemented");
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return new PutStylesKvpReader(params, (WMS)this.getServiceRef());
    }

    protected XmlRequestReader getXmlRequestReader() {
        throw new UnsupportedOperationException("Method getXmlRequestReader() not yet implemented.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PutStylesRequest serviceRequest;
        LOGGER.info("PutStyles.doGet()");
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        PutStylesKvpReader requestReader = new PutStylesKvpReader(requestParams, (WMS)this.getServiceRef());
        try {
            serviceRequest = (PutStylesRequest)requestReader.getRequest(request);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        ServletContext context = request.getSession().getServletContext();
        try {
            this.processSLD(serviceRequest, request, response, context);
        }
        catch (SldException e) {
            throw new ServletException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.fine("PutStyles POST");
        File temp = null;
        try {
            int c;
            BufferedReader requestXml = new BufferedReader(XmlCharsetDetector.getCharsetAwareReader((InputStream)request.getInputStream()));
            temp = File.createTempFile("putStylesPost", "xml");
            FileOutputStream fos = new FileOutputStream(temp);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            StringBuffer sb = new StringBuffer();
            if (requestXml == null) {
                throw new NullPointerException();
            }
            while (-1 != (c = ((Reader)requestXml).read())) {
                char chr = (char)c;
                out.write(c);
                sb.append(chr);
            }
            ((Reader)requestXml).close();
            out.flush();
            out.close();
            requestXml = new BufferedReader(new FileReader(temp));
            PutStylesRequest serviceRequest = new PutStylesRequest((WMS)this.getServiceRef());
            serviceRequest.setSldBody(sb.toString());
            ServletContext context = request.getSession().getServletContext();
            this.processSLD(serviceRequest, request, response, context);
        }
        catch (SldException e) {
            throw new ServletException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private Node generateDOM(Reader reader) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        Element rootNode = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource input = new InputSource(reader);
            Document dom = db.parse(input);
            rootNode = dom.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootNode;
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child;
        }
        return null;
    }

    public String getNodeValue(Node node) {
        return node.getChildNodes().item(0).getNodeValue();
    }

    public String getNodeChildValue(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child.getChildNodes().item(0).getNodeValue();
        }
        return null;
    }

    public boolean nodeNameEqual(Node n, String name) {
        if (n.getNodeName().equalsIgnoreCase(name)) {
            return true;
        }
        String nname = n.getNodeName();
        int idx = nname.indexOf(58);
        if (idx == -1) {
            return false;
        }
        return nname.substring(idx + 1).equalsIgnoreCase(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSLD(PutStylesRequest serviceRequest, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, SldException {
        File style_dir;
        LOGGER.info("Processing SLD");
        String sld_remote = serviceRequest.getSLD();
        if (sld_remote != null && !sld_remote.equals("")) {
            throw new UnsupportedOperationException("SLD= param not yet implemented. Use SLD_BODY=");
        }
        String sld_body = serviceRequest.getSldBody();
        if (sld_body == null || sld_body == "") {
            throw new IllegalArgumentException("The body of the SLD cannot be empty!");
        }
        File temp = null;
        Node rootNode = null;
        try {
            temp = File.createTempFile("putStyles", "xml");
            FileOutputStream fos = new FileOutputStream(temp);
            BufferedOutputStream tempOut = new BufferedOutputStream(fos);
            byte[] bytes = sld_body.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                tempOut.write(bytes[i]);
            }
            tempOut.flush();
            tempOut.close();
            BufferedInputStream fs = new BufferedInputStream(new FileInputStream(temp));
            CharArrayReader xml = new CharArrayReader(sld_body.toCharArray());
            rootNode = this.generateDOM(xml);
            SLDValidator validator = new SLDValidator();
            String baseURL = ResponseUtils.baseURL((HttpServletRequest)request);
            List errors = validator.validateSLD((InputStream)fs);
            if (errors.size() != 0) {
                throw new SldException(SLDValidator.getErrorMessage((Reader)xml, (List)errors));
            }
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        Node n_namedLayer = this.getNode(rootNode, "NamedLayer");
        Node n_layerName = this.getNode(n_namedLayer, "Name");
        Node n_userStyle = this.getNode(n_namedLayer, "UserStyle");
        Node n_styleName = this.getNode(n_userStyle, "Name");
        String layerName = this.getNodeValue(n_layerName);
        String styleName = this.getNodeValue(n_styleName);
        LOGGER.info("PutStyles SLD:\nLayer: " + layerName + ", style: " + styleName);
        StyleInfoImpl style = new StyleInfoImpl(this.getCatalog());
        style.setId(styleName);
        File data_dir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            style_dir = GeoserverDataDirectory.findConfigDir((File)data_dir, (String)"styles");
        }
        catch (ConfigurationException cfe) {
            LOGGER.warning("no style dir found, creating new one");
            style_dir = new File(data_dir, "styles");
        }
        File styleFile = new File(style_dir, styleName + ".sld");
        LOGGER.info("Saving new SLD file to " + styleFile.getPath());
        StringBuffer sldText = new StringBuffer();
        sldText.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sldText.append("<StyledLayerDescriptor version=\"1.0.0\"\n");
        sldText.append("\txsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\"\n");
        sldText.append("\txmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\"\n");
        sldText.append("\txmlns:xlink=\"http://www.w3.org/1999/xlink\"\n");
        sldText.append("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        FileOutputStream style_fos = new FileOutputStream(styleFile);
        String sldBody = serviceRequest.getSldBody();
        int start = sldBody.indexOf("<NamedLayer>");
        int end = sldBody.indexOf("</NamedLayer>");
        sldText.append(sldBody.substring(start, end));
        sldText.append("</NamedLayer>\n");
        sldText.append("</StyledLayerDescriptor>");
        style_fos.write(sldText.toString().getBytes());
        style_fos.flush();
        style_fos.close();
        style.setFilename(styleFile.getAbsolutePath());
        this.getCatalog().add((StyleInfo)style);
        List keys = this.getCatalog().getLayers();
        Iterator it = keys.iterator();
        layerName = null;
        while (it.hasNext()) {
            String o = ((LayerInfo)it.next()).getName();
            String[] os = o.split(":");
            String name = os.length == 1 ? os[0] : os[1];
            if (!name.equalsIgnoreCase(layerName)) continue;
            layerName = o;
            break;
        }
        if (layerName != null) {
            LayerInfo featureTypeConfig = this.getCatalog().getLayerByName(layerName);
            featureTypeConfig.setDefaultStyle((StyleInfo)style);
        }
        LOGGER.info("sending back result");
        String message = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sld:success>success</sld:success>";
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] msg = message.getBytes();
        out.write(msg);
        out.flush();
    }
}

