/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.sql.Connection;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.CachedHierarchyRegionatingStrategy;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;

public class NativeSortRegionatingStrategy
extends CachedHierarchyRegionatingStrategy {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    String attribute;
    FeatureSource fs;

    public NativeSortRegionatingStrategy(GeoServer gs) {
        super(gs);
    }

    @Override
    protected String getDatabaseName(WMSMapContent con, Layer layer) throws Exception {
        this.fs = layer.getFeatureSource();
        SimpleFeatureType type = (SimpleFeatureType)this.fs.getSchema();
        Map options = con.getRequest().getFormatOptions();
        this.attribute = (String)options.get("regionateAttr");
        if (this.attribute == null) {
            this.attribute = MapLayerInfo.getRegionateAttribute(this.featureType);
        }
        if (this.attribute == null) {
            throw new ServiceException("Regionating attribute has not been specified");
        }
        AttributeType attributeType = type.getType(this.attribute);
        if (attributeType == null) {
            throw new ServiceException("Could not find regionating attribute " + this.attribute + " in layer " + this.featureType.getName());
        }
        if (!this.fs.getQueryCapabilities().supportsSorting(new SortBy[]{ff.sort(this.attribute, SortOrder.DESCENDING)})) {
            throw new ServiceException("Native sorting on the " + this.attribute + " is not possible for layer " + this.featureType.getName());
        }
        return super.getDatabaseName(con, layer) + "_" + this.attribute;
    }

    @Override
    protected String getDatabaseName(FeatureTypeInfo cfg) throws Exception {
        return super.getDatabaseName(cfg) + "_" + MapLayerInfo.getRegionateAttribute(cfg);
    }

    @Override
    public FeatureIterator getSortedFeatures(GeometryDescriptor geom, ReferencedEnvelope latLongEnv, ReferencedEnvelope nativeEnv, Connection cacheConn) throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX filter = ff.bbox(geom.getLocalName(), nativeEnv.getMinX(), nativeEnv.getMinY(), nativeEnv.getMaxX(), nativeEnv.getMaxY(), null);
        Query q = new Query();
        q.setFilter((Filter)filter);
        q.setPropertyNames(new String[]{geom.getLocalName(), this.attribute});
        q.setSortBy(new SortBy[]{ff.sort(this.attribute, SortOrder.DESCENDING)});
        return this.fs.getFeatures(q).features();
    }
}

