/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.geoserver.kml.KMLTransformer;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.PNGMapResponse;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.map.XMLTransformerMap;
import org.geotools.map.Layer;
import org.geotools.xml.transform.TransformerBase;
import org.springframework.util.Assert;

public class KMZMapResponse
extends AbstractMapResponse {
    private WMS wms;

    public KMZMapResponse(WMS wms) {
        super(KMZMap.class, KMZMapOutputFormat.OUTPUT_FORMATS);
        this.wms = wms;
    }

    @Override
    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(XMLTransformerMap.class, (Object)value);
        XMLTransformerMap map = (XMLTransformerMap)value;
        try {
            KMLTransformer transformer = (KMLTransformer)map.getTransformer();
            WMSMapContent mapContent = (WMSMapContent)((Object)map.getTransformerSubject());
            ZipOutputStream zip = new ZipOutputStream(output);
            ZipEntry entry = new ZipEntry("wms.kml");
            zip.putNextEntry(entry);
            try {
                transformer.transform((Object)mapContent, zip);
                zip.closeEntry();
            }
            catch (TransformerException e) {
                throw (IOException)new IOException().initCause(e);
            }
            RenderedImageMapOutputFormat pngProducer = new RenderedImageMapOutputFormat("image/png", this.wms);
            PNGMapResponse pngEncoder = new PNGMapResponse(this.wms);
            ZipEntry images = new ZipEntry("images/");
            zip.putNextEntry(images);
            List layers = mapContent.layers();
            for (int i = 0; i < layers.size(); ++i) {
                RenderedImageMap imageMap;
                Layer mapLayer = (Layer)layers.get(i);
                WMSMapContent subContext = new WMSMapContent();
                subContext.addLayer(mapLayer);
                subContext.setRequest(mapContent.getRequest());
                subContext.setMapHeight(mapContent.getMapHeight());
                subContext.setMapWidth(mapContent.getMapWidth());
                subContext.getViewport().setBounds(mapContent.getRenderingArea());
                subContext.setBgColor(mapContent.getBgColor());
                subContext.setBuffer(mapContent.getBuffer());
                subContext.setContactInformation(mapContent.getContactInformation());
                subContext.setKeywords(mapContent.getKeywords());
                subContext.setAbstract(mapContent.getAbstract());
                subContext.setTransparent(true);
                try {
                    imageMap = pngProducer.produceMap(subContext);
                }
                finally {
                    subContext.dispose();
                }
                entry = new ZipEntry("images/layer_" + i + ".png");
                zip.putNextEntry(entry);
                pngEncoder.write(imageMap, zip, operation);
                zip.closeEntry();
            }
            zip.closeEntry();
            zip.finish();
            zip.flush();
        }
        finally {
            map.dispose();
        }
    }

    public static class KMZMap
    extends XMLTransformerMap {
        public KMZMap(WMSMapContent mapContent, TransformerBase transformer, String mimeType) {
            super(mapContent, transformer, (Object)mapContent, mimeType);
        }
    }
}

