/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.IOException;
import java.nio.charset.Charset;
import org.geoserver.kml.KMLMapOutputFormat;
import org.geoserver.kml.KMLTransformer;
import org.geoserver.kml.KMZMapResponse;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.AbstractMapOutputFormat;

public class KMZMapOutputFormat
extends AbstractMapOutputFormat {
    static final String MIME_TYPE = "application/vnd.google-earth.kmz";
    public static final String[] OUTPUT_FORMATS = new String[]{"application/vnd.google-earth.kmz", "application/vnd.google-earth.kmz+xml", "kmz", "application/vnd.google-earth.kmz xml"};
    private WMS wms;

    public KMZMapOutputFormat(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMATS);
        this.wms = wms;
    }

    @Override
    public KMZMapResponse.KMZMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        KMLTransformer transformer = new KMLTransformer(this.wms);
        transformer.setKmz(true);
        Charset encoding = this.wms.getCharSet();
        transformer.setEncoding(encoding);
        transformer.setIndentation(3);
        KMZMapResponse.KMZMap map = new KMZMapResponse.KMZMap(mapContent, transformer, MIME_TYPE);
        map.setContentDispositionHeader(mapContent, ".kmz");
        return map;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return KMLMapOutputFormat.KML_CAPABILITIES;
    }
}

