/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.KMLGeometryTransformer;
import org.geoserver.kml.KMLLookAt;
import org.geoserver.kml.KMLLookAtTransformer;
import org.geoserver.kml.KMLMapTransformer;
import org.geoserver.kml.KMLUtils;
import org.geoserver.kml.RegionatingStrategy;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Symbolizer;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class KMLVectorTransformer
extends KMLMapTransformer {
    private KMLLookAt lookAtOpts;

    public KMLVectorTransformer(WMS wms, WMSMapContent mapContent, Layer mapLayer) {
        this(wms, mapContent, mapLayer, null);
    }

    public KMLVectorTransformer(WMS wms, WMSMapContent mapContent, Layer mapLayer, KMLLookAt lookAtOpts) {
        super(wms, mapContent, mapLayer);
        this.setNamespaceDeclarationEnabled(false);
        this.lookAtOpts = lookAtOpts;
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    protected class KMLTranslator
    extends KMLMapTransformer.KMLMapTranslatorSupport {
        private RegionatingStrategy myStrategy;

        public KMLTranslator(ContentHandler contentHandler) {
            super(contentHandler);
            KMLGeometryTransformer geometryTransformer = new KMLGeometryTransformer();
            geometryTransformer.setOmitXMLDeclaration(true);
            geometryTransformer.setNamespaceDeclarationEnabled(true);
            GeoServer config = KMLVectorTransformer.this.wms.getGeoServer();
            geometryTransformer.setNumDecimals(config.getSettings().getNumDecimals());
            this.geometryTranslator = (KMLGeometryTransformer.KMLGeometryTranslator)geometryTransformer.createTranslator(contentHandler, KMLVectorTransformer.this.mapContent);
        }

        public void setRegionatingStrategy(RegionatingStrategy rs) {
            this.myStrategy = rs;
        }

        public void encode(Object o) throws IllegalArgumentException {
            ReferencedEnvelope bounds;
            SimpleFeatureCollection features = (SimpleFeatureCollection)o;
            SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
            if (KMLVectorTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Document", KMLUtils.attributes(new String[]{"xmlns:atom", "http://purl.org/atom/ns#"}));
            String kmltitle = (String)KMLVectorTransformer.this.mapContent.getRequest().getFormatOptions().get("kmltitle");
            this.element("name", kmltitle != null && KMLVectorTransformer.this.mapContent.layers().size() <= 1 ? kmltitle : KMLVectorTransformer.this.mapLayer.getTitle());
            if (KMLVectorTransformer.this.lookAtOpts != null && (bounds = features.getBounds()) != null) {
                KMLLookAtTransformer tx = new KMLLookAtTransformer((Envelope)bounds, KMLVectorTransformer.this.getIndentation(), KMLVectorTransformer.this.getEncoding());
                Translator translator = tx.createTranslator(this.contentHandler);
                translator.encode((Object)KMLVectorTransformer.this.lookAtOpts);
            }
            String relLinks = (String)KMLVectorTransformer.this.mapContent.getRequest().getFormatOptions().get("relLinks");
            if (KMLVectorTransformer.this.mapContent.getRequest().getMaxFeatures() != null && relLinks != null && relLinks.equalsIgnoreCase("true")) {
                String linkbase = "";
                try {
                    linkbase = this.getFeatureTypeURL();
                    linkbase = linkbase + ".kml";
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                int maxFeatures = KMLVectorTransformer.this.mapContent.getRequest().getMaxFeatures();
                int startIndex = KMLVectorTransformer.this.mapContent.getRequest().getStartIndex() == null ? 0 : KMLVectorTransformer.this.mapContent.getRequest().getStartIndex();
                int prevStart = startIndex - maxFeatures;
                int nextStart = startIndex + maxFeatures;
                if (prevStart >= 0) {
                    String prevLink = linkbase + "?startindex=" + prevStart + "&maxfeatures=" + maxFeatures;
                    this.element("atom:link", null, KMLUtils.attributes(new String[]{"rel", "prev", "href", prevLink}));
                    this.encodeSequentialNetworkLink(linkbase, prevStart, maxFeatures, "prev", "Previous page");
                }
                if (features.size() >= maxFeatures) {
                    String nextLink = linkbase + "?startindex=" + nextStart + "&maxfeatures=" + maxFeatures;
                    this.element("atom:link", null, KMLUtils.attributes(new String[]{"rel", "next", "href", nextLink}));
                    this.encodeSequentialNetworkLink(linkbase, nextStart, maxFeatures, "next", "Next page");
                }
            }
            FeatureTypeStyle[] featureTypeStyles = KMLUtils.filterFeatureTypeStyles(KMLVectorTransformer.this.mapLayer.getStyle(), featureType);
            this.encodeSchemas(features);
            this.encode(features, featureTypeStyles);
            this.end("Document");
            if (KMLVectorTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        private void encodeSequentialNetworkLink(String linkbase, int prevStart, int maxFeatures, String id, String readableName) {
            String link = linkbase + "?startindex=" + prevStart + "&maxfeatures=" + maxFeatures;
            this.start("NetworkLink", KMLUtils.attributes(new String[]{"id", id}));
            this.element("description", readableName);
            this.start("Link");
            this.element("href", link);
            this.end("Link");
            this.end("NetworkLink");
        }

        protected void encodeSchemas(SimpleFeatureCollection featureTypeStyles) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(SimpleFeatureCollection features, FeatureTypeStyle[] styles) {
            SimpleFeatureIterator reader = null;
            try {
                reader = features.features();
                while (reader.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    try {
                        List<Symbolizer> symbolizers = this.filterSymbolizers(feature, styles);
                        if (symbolizers.size() <= 0) continue;
                        this.encodePlacemark(feature, symbolizers, KMLVectorTransformer.this.lookAtOpts);
                    }
                    catch (RuntimeException t) {
                        if (t.getCause() instanceof SAXException) {
                            throw t;
                        }
                        KMLMapTransformer.LOGGER.log(Level.WARNING, "Failure tranforming feature to KML:" + feature.getID(), t);
                    }
                }
            }
            finally {
                features.close((FeatureIterator)reader);
            }
        }
    }
}

