/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.RegionatingStrategy;
import org.geoserver.kml.RegionatingStrategyFactory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class KMLUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    static final double TOLERANCE = 1.0E-6;
    private static final int RULES = 0;
    private static final int ELSE_RULES = 1;
    public static final Envelope WORLD_BOUNDS_WGS84 = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private static final double[] TILE_RESOLUTIONS = new double[100];
    private static FilterFactory filterFactory;

    public static String getMapUrl(WMSMapContent mapContent, Layer layer, int layerIndex, Envelope bbox, String[] kvp, boolean tile, GeoServer geoserver) {
        if (tile) {
            GetMapRequest request = mapContent.getRequest();
            return WMSRequests.getTiledGetMapUrl(geoserver, request, layer, layerIndex, bbox, kvp);
        }
        return WMSRequests.getGetMapUrl(mapContent.getRequest(), layer, layerIndex, bbox, kvp);
    }

    public static String getMapUrl(WMSMapContent mapContent, Layer layer, int layerIndex, boolean tile, GeoServer geoserver) {
        return KMLUtils.getMapUrl(mapContent, layer, layerIndex, (Envelope)mapContent.getRenderingArea(), null, tile, geoserver);
    }

    public static String getLegendGraphicUrl(WMSMapContent mapContent, Layer layer, String[] kvp) {
        return WMSRequests.getGetLegendGraphicUrl(mapContent.getRequest(), layer, kvp);
    }

    public static Attributes attributes(String[] nameValuePairs) {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            String name = nameValuePairs[i];
            String value = nameValuePairs[i + 1];
            attributes.addAttribute("", name, name, "", value);
        }
        return attributes;
    }

    public static Rule[] filterRules(FeatureTypeStyle featureTypeStyle, SimpleFeature feature, double scaleDenominator) {
        Rule rule;
        int i;
        Rule[] rules = featureTypeStyle.getRules();
        if (rules == null || rules.length == 0) {
            return new Rule[0];
        }
        ArrayList<Rule> filtered = new ArrayList<Rule>(rules.length);
        boolean match = false;
        boolean hasElseFilter = false;
        for (i = 0; i < rules.length; ++i) {
            Filter filter;
            rule = rules[i];
            LOGGER.finer(new StringBuffer("Applying rule: ").append(rule.toString()).toString());
            if (rule.hasElseFilter()) {
                hasElseFilter = true;
                continue;
            }
            if (!KMLUtils.isWithInScale(rule, scaleDenominator) || (filter = rule.getFilter()) != null && !filter.evaluate((Object)feature)) continue;
            match = true;
            filtered.add(rule);
        }
        if (!match && hasElseFilter) {
            for (i = 0; i < rules.length; ++i) {
                rule = rules[i];
                if (!KMLUtils.isWithInScale(rule, scaleDenominator) || !rule.hasElseFilter()) continue;
                filtered.add(rule);
            }
        }
        return filtered.toArray(new Rule[filtered.size()]);
    }

    public static boolean isWithInScale(Rule r, double scaleDenominator) {
        return r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator;
    }

    public static int findZoomLevel(Envelope extent) {
        int i;
        double resolution = Math.max(extent.getWidth() / 256.0, extent.getHeight() / 256.0);
        for (i = 1; i < TILE_RESOLUTIONS.length; ++i) {
            if (!(resolution > TILE_RESOLUTIONS[i])) continue;
            --i;
            break;
        }
        return i;
    }

    public static Envelope expandToTile(Envelope extent) {
        double resolution = Math.max(extent.getWidth() / 256.0, extent.getHeight() / 256.0);
        for (int i = KMLUtils.findZoomLevel(extent); i > 0; --i) {
            resolution = TILE_RESOLUTIONS[i];
            double tilelon = resolution * 256.0;
            double tilelat = resolution * 256.0;
            double lon0 = extent.getMinX() - WORLD_BOUNDS_WGS84.getMinX();
            double lon1 = extent.getMaxX() - WORLD_BOUNDS_WGS84.getMinX();
            int col0 = (int)Math.floor(lon0 / tilelon);
            int col1 = (int)Math.floor(lon1 / tilelon - 1.0E-9);
            double lat0 = extent.getMinY() - WORLD_BOUNDS_WGS84.getMinY();
            double lat1 = extent.getMaxY() - WORLD_BOUNDS_WGS84.getMinY();
            int row0 = (int)Math.floor(lat0 / tilelat);
            int row1 = (int)Math.floor(lat1 / tilelat - 1.0E-9);
            if (col0 != col1 || row0 != row1) continue;
            double tileoffsetlon = WORLD_BOUNDS_WGS84.getMinX() + (double)col0 * tilelon;
            double tileoffsetlat = WORLD_BOUNDS_WGS84.getMinY() + (double)row0 * tilelat;
            return new Envelope(tileoffsetlon, tileoffsetlon + tilelon, tileoffsetlat, tileoffsetlat + tilelat);
        }
        return WORLD_BOUNDS_WGS84;
    }

    public static String intToHex(int i) {
        String prelim = Integer.toHexString(i);
        if (prelim.length() < 2) {
            prelim = "0" + prelim;
        }
        return prelim;
    }

    public static String colorToHex(Color c, double opacity) {
        return new StringBuffer().append(KMLUtils.intToHex(new Float(255.0 * opacity).intValue())).append(KMLUtils.intToHex(c.getBlue())).append(KMLUtils.intToHex(c.getGreen())).append(KMLUtils.intToHex(c.getRed())).toString();
    }

    public static FeatureTypeStyle[] filterFeatureTypeStyles(Style style, SimpleFeatureType ftype) {
        List featureTypeStyles = style.featureTypeStyles();
        if (featureTypeStyles == null || featureTypeStyles.isEmpty()) {
            return new FeatureTypeStyle[0];
        }
        ArrayList<FeatureTypeStyle> filtered = new ArrayList<FeatureTypeStyle>(featureTypeStyles.size());
        for (FeatureTypeStyle fts : featureTypeStyles) {
            String ftName = fts.getFeatureTypeName();
            if (!fts.featureTypeNames().isEmpty() && (ftype.getName().getLocalPart() == null || !ftype.getName().getLocalPart().equalsIgnoreCase(ftName) && !FeatureTypes.isDecendedFrom((FeatureType)ftype, null, (String)ftName))) continue;
            filtered.add(fts);
        }
        return filtered.toArray(new FeatureTypeStyle[filtered.size()]);
    }

    public static SimpleFeatureCollection loadFeatureCollection(SimpleFeatureSource featureSource, Layer layer, WMSMapContent mapContent, WMS wms, double scaleDenominator) throws Exception {
        CoordinateReferenceSystem wgs84;
        Name name;
        Catalog catalog;
        boolean reprojectBBox;
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        ReferencedEnvelope envelope = mapContent.getRenderingArea();
        ReferencedEnvelope aoi = new ReferencedEnvelope((Envelope)envelope, mapContent.getCoordinateReferenceSystem());
        CoordinateReferenceSystem sourceCrs = schema.getCoordinateReferenceSystem();
        boolean bl = reprojectBBox = sourceCrs != null && !CRS.equalsIgnoreMetadata((Object)aoi.getCoordinateReferenceSystem(), (Object)sourceCrs);
        if (reprojectBBox) {
            aoi = aoi.transform(sourceCrs, true);
        }
        Filter filter = KMLUtils.createBBoxFilter(schema, (Envelope)aoi);
        Query q = new Query(schema.getTypeName());
        q.setFilter(filter);
        Query definitionQuery = layer.getQuery();
        if (definitionQuery != Query.ALL) {
            q = q == Query.ALL ? definitionQuery : DataUtilities.mixQueries((Query)definitionQuery, (Query)q, (String)"KMLEncoder");
        }
        q.setStartIndex(definitionQuery.getStartIndex());
        RegionatingStrategy regionatingStrategy = null;
        String stratname = (String)mapContent.getRequest().getFormatOptions().get("regionateBy");
        if ("auto".equals(stratname) && ((stratname = (String)(catalog = wms.getGeoServer().getCatalog()).getFeatureTypeByName(name = layer.getFeatureSource().getName()).getMetadata().get("kml.regionateStrategy", String.class)) == null || "".equals(stratname))) {
            stratname = "best_guess";
            LOGGER.log(Level.FINE, "No default regionating strategy has been configured in " + name + "; using automatic best-guess strategy.");
        }
        if (stratname != null && (regionatingStrategy = KMLUtils.findStrategyByName(stratname)) == null) {
            throw new ServiceException("Unknown regionating strategy " + stratname);
        }
        IncludeFilter regionatingFilter = Filter.INCLUDE;
        if (regionatingStrategy != null) {
            regionatingFilter = regionatingStrategy.getFilter(mapContent, layer);
        }
        Filter ruleFilter = KMLUtils.summarizeRuleFilters(KMLUtils.getLayerRules((SimpleFeatureType)featureSource.getSchema(), layer.getStyle()), scaleDenominator);
        Filter finalFilter = KMLUtils.joinFilters(new Filter[]{q.getFilter(), ruleFilter, regionatingFilter});
        if (finalFilter == Filter.EXCLUDE) {
            return null;
        }
        q.setFilter(finalFilter);
        try {
            wgs84 = CRS.decode((String)"EPSG:4326");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot decode EPSG:4326, the CRS subsystem must be badly broken...");
        }
        if (sourceCrs != null && !CRS.equalsIgnoreMetadata((Object)wgs84, (Object)sourceCrs)) {
            return new ReprojectFeatureResults((FeatureCollection)featureSource.getFeatures(q), wgs84);
        }
        return featureSource.getFeatures(q);
    }

    public static RegionatingStrategy findStrategyByName(String name) {
        List factories = GeoServerExtensions.extensions(RegionatingStrategyFactory.class);
        for (RegionatingStrategyFactory factory : factories) {
            if (!factory.canHandle(name)) continue;
            return factory.createStrategy();
        }
        return null;
    }

    private static Filter createBBoxFilter(SimpleFeatureType schema, Envelope bbox) throws IllegalFilterException {
        ArrayList<BBOX> filters = new ArrayList<BBOX>();
        for (int j = 0; j < schema.getAttributeCount(); ++j) {
            AttributeDescriptor attType = schema.getDescriptor(j);
            if (!(attType instanceof GeometryDescriptor)) continue;
            BBOX gfilter = filterFactory.bbox(attType.getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
            filters.add(gfilter);
        }
        if (filters.size() == 0) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return filterFactory.or(filters);
    }

    private static List[] getLayerRules(SimpleFeatureType ftype, Style style) {
        List[] result = new List[]{new ArrayList(), new ArrayList()};
        String typeName = ftype.getTypeName();
        for (FeatureTypeStyle fts : KMLUtils.filterFeatureTypeStyles(style, ftype)) {
            Rule[] ftsRules = fts.getRules();
            for (int j = 0; j < ftsRules.length; ++j) {
                Rule r = ftsRules[j];
                if (r.hasElseFilter()) {
                    result[1].add(r);
                    continue;
                }
                result[0].add(r);
            }
        }
        return result;
    }

    private static Filter joinFilters(Filter ... filters) {
        if (filters == null || filters.length == 0) {
            return Filter.EXCLUDE;
        }
        And result = null;
        if (filters.length > 0) {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            result = ff.and(Arrays.asList(filters));
        } else if (filters.length == 1) {
            result = filters[0];
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        return (Filter)result.accept((FilterVisitor)visitor, null);
    }

    private static Filter summarizeRuleFilters(List[] rules, double scaleDenominator) {
        if (rules[0].size() == 0 && rules[1].size() > 0) {
            return Filter.EXCLUDE;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Rule rule : rules[0]) {
            if (!(scaleDenominator <= 0.0) && !KMLUtils.isWithInScale(rule, scaleDenominator)) continue;
            if (rule.getFilter() == null || Filter.INCLUDE.equals(rule.getFilter())) {
                return Filter.INCLUDE;
            }
            filters.add(rule.getFilter());
        }
        if (filters.size() > 0) {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            return ff.or(filters);
        }
        return Filter.EXCLUDE;
    }

    public static String getSuperoverlayMode(GetMapRequest request, WMS wms) {
        String overlayMode = (String)request.getFormatOptions().get("superoverlay_mode");
        if (overlayMode != null) {
            return overlayMode;
        }
        overlayMode = (String)request.getFormatOptions().get("overlayMode");
        if (overlayMode != null) {
            return overlayMode;
        }
        return wms.getKmlSuperoverlayMode();
    }

    public static boolean getKMAttr(GetMapRequest request, WMS wms) {
        Object kmattr = request.getFormatOptions().get("kmattr");
        if (kmattr != null) {
            return (Boolean)Converters.convert(kmattr, Boolean.class);
        }
        return wms.getKmlKmAttr();
    }

    public static boolean getKmplacemark(GetMapRequest request, WMS wms) {
        Object kmplacemark = request.getFormatOptions().get("kmplacemark");
        if (kmplacemark != null) {
            return (Boolean)Converters.convert(kmplacemark, Boolean.class);
        }
        return wms.getKmlPlacemark();
    }

    public static int getKmScore(GetMapRequest request, WMS wms) {
        Object kmscore = request.getFormatOptions().get("kmscore");
        if (kmscore != null) {
            return (Integer)Converters.convert(kmscore, Integer.class);
        }
        return wms.getKmScore();
    }

    public static boolean isRequestGWCCompatible(GetMapRequest request, int layerIndex, WMS wms) {
        boolean requestKmAttr = KMLUtils.getKMAttr(request, wms);
        if (requestKmAttr != wms.getKmlKmAttr()) {
            return false;
        }
        boolean requestKmplacemark = KMLUtils.getKmplacemark(request, wms);
        if (requestKmplacemark != wms.getKmlPlacemark()) {
            return false;
        }
        int requestKmscore = KMLUtils.getKmScore(request, wms);
        if (requestKmscore != wms.getKmScore()) {
            return false;
        }
        if (request.getLayers().get(layerIndex).getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            return false;
        }
        Style requestedStyle = request.getStyles().get(layerIndex);
        Style defaultStyle = request.getLayers().get(layerIndex).getDefaultStyle();
        if (!defaultStyle.equals(requestedStyle)) {
            return false;
        }
        List filters = request.getFilter();
        if (filters != null && filters.size() > 0 && filters.get(layerIndex) != Filter.INCLUDE) {
            return false;
        }
        String antialias = (String)request.getFormatOptions().get("antialias");
        if (antialias != null && !"FULL".equalsIgnoreCase(antialias)) {
            return false;
        }
        if (request.getPalette() != null) {
            return false;
        }
        if (request.getStartIndex() != null && request.getStartIndex() != 0) {
            return false;
        }
        if (request.getMaxFeatures() != null) {
            return false;
        }
        return request.getViewParams() == null || request.getViewParams().size() <= 0;
    }

    public static boolean isRequestGWCCompatible(WMSMapContent mapContent, Layer layer, WMS wms) {
        List layers = mapContent.layers();
        for (int i = 0; i < layers.size(); ++i) {
            if (layers.get(i) != layer) continue;
            return KMLUtils.isRequestGWCCompatible(mapContent.getRequest(), i, wms);
        }
        LOGGER.warning("Could not find map layer " + layer.getTitle() + " in the map context");
        return false;
    }

    static {
        for (int i = 0; i < TILE_RESOLUTIONS.length; ++i) {
            KMLUtils.TILE_RESOLUTIONS[i] = WORLD_BOUNDS_WGS84.getWidth() / (double)((1 << i) * 256);
        }
        filterFactory = CommonFactoryFinder.getFilterFactory(null);
    }
}

