/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.kml.KMLLegendTransformer;
import org.geoserver.kml.KMLLookAt;
import org.geoserver.kml.KMLRasterTransformer;
import org.geoserver.kml.KMLSuperOverlayTransformer;
import org.geoserver.kml.KMLTransformerBase;
import org.geoserver.kml.KMLUtils;
import org.geoserver.kml.KMLVectorTransformer;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;

public class KMLTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    boolean kmz = false;
    private WMS wms;

    public KMLTransformer(WMS wms) {
        this.wms = wms;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    public void setKmz(boolean kmz) {
        this.kmz = kmz;
    }

    protected class KMLTranslator
    extends TransformerBase.TranslatorSupport {
        static final double TOLERANCE = 1.0E-6;
        static final int RULES = 0;
        static final int ELSE_RULES = 1;
        private double scaleDenominator;

        public KMLTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            Layer layer;
            int i;
            boolean group;
            WMSMapContent mapContent = (WMSMapContent)((Object)o);
            GetMapRequest request = mapContent.getRequest();
            List layers = mapContent.layers();
            KMLLookAt lookAtOpts = new KMLLookAt(request.getFormatOptions());
            this.start("kml", KMLUtils.attributes(new String[]{"xmlns", "http://www.opengis.net/kml/2.2", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd"}));
            this.scaleDenominator = 1.0;
            try {
                this.scaleDenominator = RendererUtilities.calculateScale((ReferencedEnvelope)mapContent.getRenderingArea(), (int)mapContent.getMapWidth(), (int)mapContent.getMapHeight(), null);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error calculating scale denominator", e);
            }
            LOGGER.log(Level.FINE, "scale denominator = " + this.scaleDenominator);
            boolean bl = group = layers.size() > 1 || request.getLegend();
            if (group) {
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < layers.size(); ++i2) {
                    sb.append(((Layer)layers.get(i2)).getTitle() + ",");
                }
                sb.setLength(sb.length() - 1);
                this.start("Document");
                String kmltitle = (String)mapContent.getRequest().getFormatOptions().get("kmltitle");
                this.element("name", kmltitle != null ? kmltitle : sb.toString());
            }
            for (i = 0; i < layers.size(); ++i) {
                layer = (Layer)layers.get(i);
                MapLayerInfo layerInfo = mapContent.getRequest().getLayers().get(i);
                Boolean superoverlay = (Boolean)mapContent.getRequest().getFormatOptions().get("superoverlay");
                Boolean bl2 = superoverlay = superoverlay == null ? Boolean.FALSE : superoverlay;
                if (superoverlay.booleanValue()) {
                    this.encodeSuperOverlayLayer(mapContent, layer);
                    continue;
                }
                if (layerInfo.getType() != MapLayerInfo.TYPE_RASTER) {
                    this.encodeVectorLayer(mapContent, layer, lookAtOpts);
                    continue;
                }
                this.encodeRasterLayer(mapContent, layer, lookAtOpts);
            }
            if (request.getLegend()) {
                for (i = 0; i < layers.size(); ++i) {
                    layer = (Layer)layers.get(i);
                    this.encodeLegend(mapContent, layer);
                }
            }
            if (group) {
                this.end("Document");
            }
            this.end("kml");
        }

        protected void encodeVectorLayer(WMSMapContent mapContent, Layer layer, KMLLookAt lookAtOpts) {
            SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeatureSource();
            SimpleFeatureCollection features = null;
            try {
                features = KMLUtils.loadFeatureCollection(featureSource, layer, mapContent, KMLTransformer.this.wms, this.scaleDenominator);
                if (features == null) {
                    return;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (KMLTransformer.this.kmz) {
                boolean useVector;
                int kmscore = KMLTransformer.this.wms.getKmScore();
                Object kmScoreObj = mapContent.getRequest().getFormatOptions().get("kmscore");
                if (kmScoreObj != null) {
                    kmscore = (Integer)kmScoreObj;
                }
                if (useVector = this.useVectorOutput(kmscore, features.size())) {
                    KMLVectorTransformer tx = this.createVectorTransformer(mapContent, layer, lookAtOpts);
                    this.initTransformer(tx);
                    tx.setScaleDenominator(this.scaleDenominator);
                    tx.createTranslator(this.contentHandler).encode((Object)features);
                } else {
                    KMLRasterTransformer tx = this.createRasterTransfomer(mapContent, lookAtOpts);
                    this.initTransformer(tx);
                    tx.setInline(true);
                    tx.createTranslator(this.contentHandler).encode((Object)layer);
                }
            } else {
                KMLVectorTransformer tx = this.createVectorTransformer(mapContent, layer, lookAtOpts);
                this.initTransformer(tx);
                tx.setScaleDenominator(this.scaleDenominator);
                tx.createTranslator(this.contentHandler).encode((Object)features);
            }
        }

        protected KMLRasterTransformer createRasterTransfomer(WMSMapContent mapContent, KMLLookAt lookAtOpts) {
            return new KMLRasterTransformer(KMLTransformer.this.wms, mapContent, lookAtOpts);
        }

        protected KMLVectorTransformer createVectorTransformer(WMSMapContent mapContent, Layer layer, KMLLookAt lookAtOpts) {
            return new KMLVectorTransformer(KMLTransformer.this.wms, mapContent, layer, lookAtOpts);
        }

        protected void encodeRasterLayer(WMSMapContent mapContent, Layer layer, KMLLookAt lookAtOpts) {
            KMLRasterTransformer tx = this.createRasterTransfomer(mapContent, lookAtOpts);
            this.initTransformer(tx);
            tx.setInline(KMLTransformer.this.kmz);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeSuperOverlayLayer(WMSMapContent mapContent, Layer layer) {
            KMLSuperOverlayTransformer tx = new KMLSuperOverlayTransformer(KMLTransformer.this.wms, mapContent);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeLegend(WMSMapContent mapContent, Layer layer) {
            KMLLegendTransformer tx = new KMLLegendTransformer(mapContent);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void initTransformer(KMLTransformerBase delegate) {
            delegate.setIndentation(KMLTransformer.this.getIndentation());
            delegate.setEncoding(KMLTransformer.this.getEncoding());
            delegate.setStandAlone(false);
        }

        double computeScaleDenominator(Layer layer, WMSMapContent mapContent) {
            Rectangle paintArea = new Rectangle(mapContent.getMapWidth(), mapContent.getMapHeight());
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapContent.getRenderingArea(), (Rectangle)paintArea);
            try {
                return RendererUtilities.calculateScale((Envelope)mapContent.getRenderingArea(), (CoordinateReferenceSystem)mapContent.getCoordinateReferenceSystem(), (int)paintArea.width, (int)paintArea.height, (double)90.0);
            }
            catch (Exception e) {
                return 1.0 / worldToScreen.getScaleX();
            }
        }

        boolean useVectorOutput(int kmscore, int numFeatures) {
            if (kmscore == 100) {
                return true;
            }
            if (kmscore == 0) {
                return false;
            }
            double magic = Math.pow(10.0, kmscore / 15);
            return !((double)numFeatures > magic);
        }
    }
}

