/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.kml.KMLLookAt;
import org.geoserver.kml.KMLLookAtTransformer;
import org.geoserver.kml.KMLMapTransformer;
import org.geoserver.kml.KMLUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Symbolizer;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;

public class KMLRasterTransformer
extends KMLMapTransformer {
    boolean inline = false;
    private KMLLookAt lookAtOpts;

    public KMLRasterTransformer(WMS wms, WMSMapContent mapContent) {
        this(wms, mapContent, (KMLLookAt)null);
    }

    public KMLRasterTransformer(WMS wms, WMSMapContent mapContent, KMLLookAt lookAtOpts) {
        super(wms, mapContent, null);
        this.lookAtOpts = lookAtOpts;
        this.setNamespaceDeclarationEnabled(false);
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLRasterTranslator(handler);
    }

    class KMLRasterTranslator
    extends KMLMapTransformer.KMLMapTranslatorSupport {
        public KMLRasterTranslator(ContentHandler handler) {
            super(KMLRasterTransformer.this, handler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            ReferencedEnvelope box;
            boolean reprojectBBox;
            Layer layer = (Layer)o;
            int mapLayerOrder = KMLRasterTransformer.this.mapContent.layers().indexOf(layer);
            if (KMLRasterTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            boolean bl = reprojectBBox = (box = new ReferencedEnvelope(KMLRasterTransformer.this.mapContent.getRenderingArea())).getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)box.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84);
            if (reprojectBBox) {
                try {
                    box = box.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw new ServiceException("Could not transform bbox to WGS84", (Throwable)e, "ReprojectionError", "");
                }
            }
            this.start("Folder");
            String kmltitle = (String)KMLRasterTransformer.this.mapContent.getRequest().getFormatOptions().get("kmltitle");
            this.element("name", kmltitle != null && KMLRasterTransformer.this.mapContent.layers().size() <= 1 ? kmltitle : "layer_" + mapLayerOrder);
            this.element("description", layer.getTitle());
            if (KMLRasterTransformer.this.lookAtOpts != null && box != null) {
                KMLLookAtTransformer tx = new KMLLookAtTransformer((Envelope)box, KMLRasterTransformer.this.getIndentation(), KMLRasterTransformer.this.getEncoding());
                Translator translator = tx.createTranslator(this.contentHandler);
                translator.encode((Object)KMLRasterTransformer.this.lookAtOpts);
            }
            this.start("GroundOverlay");
            this.element("name", layer.getTitle());
            this.element("drawOrder", Integer.toString(mapLayerOrder));
            this.start("Icon");
            this.encodeHref(layer);
            this.element("viewRefreshMode", "never");
            this.element("viewBoundScale", "0.75");
            this.end("Icon");
            this.start("LatLonBox");
            this.element("north", Double.toString(box.getMaxY()));
            this.element("south", Double.toString(box.getMinY()));
            this.element("east", Double.toString(box.getMaxX()));
            this.element("west", Double.toString(box.getMinX()));
            this.end("LatLonBox");
            this.end("GroundOverlay");
            boolean kmplacemark = KMLUtils.getKmplacemark(KMLRasterTransformer.this.mapContent.getRequest(), KMLRasterTransformer.this.wms);
            if (kmplacemark) {
                SimpleFeatureCollection features = null;
                try {
                    features = KMLUtils.loadFeatureCollection((SimpleFeatureSource)layer.getFeatureSource(), layer, KMLRasterTransformer.this.mapContent, KMLRasterTransformer.this.wms, KMLRasterTransformer.this.scaleDenominator);
                }
                catch (Exception ex) {
                    String msg = "Error getting features.";
                    KMLMapTransformer.LOGGER.log(Level.WARNING, msg, ex);
                }
                if (features != null && features.size() > 0) {
                    Geometry geom = null;
                    Point centroidGeom = null;
                    ReferencedEnvelope aoi = KMLRasterTransformer.this.mapContent.getRenderingArea();
                    GeometryFactory factory = new GeometryFactory();
                    Geometry displayGeom = factory.toGeometry(new Envelope(aoi.getMinX(), aoi.getMaxX(), aoi.getMinY(), aoi.getMaxY()));
                    SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
                    FeatureTypeStyle[] fts = KMLUtils.filterFeatureTypeStyles(layer.getStyle(), featureType);
                    for (SimpleFeature ftr : features) {
                        Geometry g1;
                        geom = (Geometry)ftr.getDefaultGeometry();
                        List<Symbolizer> symbolizers = this.filterSymbolizers(ftr, fts);
                        if (symbolizers.size() != 0) {
                            this.encodeStyle(ftr, symbolizers);
                        }
                        if (geom instanceof MultiPolygon) {
                            double maxSize = -1.0;
                            int numGeoms = geom.getNumGeometries();
                            for (int i = 0; i < numGeoms; ++i) {
                                Polygon poly = (Polygon)geom.getGeometryN(i);
                                if (!(poly.getArea() > maxSize) || !displayGeom.intersects((Geometry)poly)) continue;
                                geom = poly;
                                maxSize = poly.getArea();
                            }
                        }
                        if ((g1 = displayGeom.intersection(geom)).isEmpty()) continue;
                        centroidGeom = g1.getCentroid();
                        this.encodePlacemark(ftr, symbolizers, (Geometry)centroidGeom, KMLRasterTransformer.this.lookAtOpts);
                    }
                }
            }
            this.end("Folder");
            if (KMLRasterTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        protected void encodeHref(Layer layer) {
            if (KMLRasterTransformer.this.inline) {
                int mapLayerOrder = KMLRasterTransformer.this.mapContent.layers().indexOf(layer);
                this.element("href", "images/layer_" + mapLayerOrder + ".png");
            } else {
                this.element("href", WMSRequests.getGetMapUrl(KMLRasterTransformer.this.mapContent.getRequest(), layer, 0, (Envelope)KMLRasterTransformer.this.mapContent.getRenderingArea(), new String[]{"format", "image/png", "transparent", "true"}));
            }
        }
    }
}

