/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.kml.KMLLookAt;
import org.geoserver.kml.KMLLookAtTransformer;
import org.geoserver.kml.KMLUtils;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.ContentHandler;

public class KMLNetworkLinkTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    boolean encodeAsRegion = false;
    boolean cachedMode = false;
    private boolean standalone;
    private boolean inline;
    private final WMSMapContent mapContent;
    private WMS wms;

    public KMLNetworkLinkTransformer(WMS wms, WMSMapContent mapContent) {
        this.wms = wms;
        this.mapContent = mapContent;
        this.standalone = true;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setCachedMode(boolean cachedMode) {
        this.cachedMode = cachedMode;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLNetworkLinkTranslator(handler);
    }

    public void setEncodeAsRegion(boolean encodeAsRegion) {
        this.encodeAsRegion = encodeAsRegion;
    }

    class KMLNetworkLinkTranslator
    extends TransformerBase.TranslatorSupport {
        public KMLNetworkLinkTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContent context = (WMSMapContent)((Object)o);
            GetMapRequest request = context.getRequest();
            if ("application/vnd.google-earth.kml+xml;mode=networklink".equals(request.getFormat())) {
                request.setFormat("application/vnd.google-earth.kml+xml");
            } else {
                request.setFormat("application/vnd.google-earth.kmz");
            }
            if (KMLNetworkLinkTransformer.this.standalone) {
                this.start("kml");
            }
            if (!KMLNetworkLinkTransformer.this.inline) {
                this.start("Folder");
                if (KMLNetworkLinkTransformer.this.standalone) {
                    String kmltitle = (String)KMLNetworkLinkTransformer.this.mapContent.getRequest().getFormatOptions().get("kmltitle");
                    this.element("name", kmltitle != null ? kmltitle : "");
                }
            }
            List<MapLayerInfo> layers = request.getLayers();
            KMLLookAt lookAt = this.parseLookAtOptions(request);
            ArrayList<ReferencedEnvelope> layerBounds = new ArrayList<ReferencedEnvelope>(layers.size());
            ReferencedEnvelope aggregatedBounds = this.computePerLayerQueryBounds(context, layerBounds, lookAt);
            if (KMLNetworkLinkTransformer.this.encodeAsRegion) {
                this.encodeAsSuperOverlay(request, lookAt, layerBounds);
            } else {
                this.encodeAsOverlay(request, lookAt, layerBounds);
            }
            this.encodeLookAt((Envelope)aggregatedBounds, lookAt);
            if (!KMLNetworkLinkTransformer.this.inline) {
                this.end("Folder");
            }
            if (KMLNetworkLinkTransformer.this.standalone) {
                this.end("kml");
            }
        }

        private ReferencedEnvelope computePerLayerQueryBounds(WMSMapContent context, List<ReferencedEnvelope> target, KMLLookAt lookAt) {
            ReferencedEnvelope aggregatedBounds;
            boolean computeQueryBounds = lookAt.getLookAt() == null;
            try {
                boolean longitudeFirst = true;
                aggregatedBounds = new ReferencedEnvelope(CRS.decode((String)"EPSG:4326", (boolean)longitudeFirst));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            aggregatedBounds.setToNull();
            List mapLayers = context.layers();
            List<MapLayerInfo> layerInfos = context.getRequest().getLayers();
            for (int i = 0; i < mapLayers.size(); ++i) {
                Layer Layer2 = (Layer)mapLayers.get(i);
                MapLayerInfo layerInfo = layerInfos.get(i);
                ReferencedEnvelope layerLatLongBbox = this.computeLayerBounds(Layer2, layerInfo, computeQueryBounds);
                try {
                    layerLatLongBbox = layerLatLongBbox.transform(aggregatedBounds.getCoordinateReferenceSystem(), true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                target.add(layerLatLongBbox);
                aggregatedBounds.expandToInclude((Envelope)layerLatLongBbox);
            }
            return aggregatedBounds;
        }

        private ReferencedEnvelope computeLayerBounds(Layer layer, MapLayerInfo layerInfo, boolean computeQueryBounds) {
            Query layerQuery = layer.getQuery();
            Filter filter = layerQuery.getFilter();
            if (layerQuery.getFilter() == null || Filter.INCLUDE.equals(filter)) {
                computeQueryBounds = false;
            }
            if (!computeQueryBounds && !layerQuery.isMaxFeaturesUnlimited()) {
                computeQueryBounds = true;
            }
            ReferencedEnvelope layerLatLongBbox = null;
            if (computeQueryBounds) {
                FeatureSource featureSource = layer.getFeatureSource();
                try {
                    CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
                    FeatureCollection features = featureSource.getFeatures(layerQuery);
                    layerLatLongBbox = features.getBounds();
                    layerLatLongBbox = layerLatLongBbox.transform(targetCRS, true);
                }
                catch (Exception e) {
                    LOGGER.info("Error computing bounds for " + featureSource.getName() + " with " + layerQuery);
                }
            }
            if (layerLatLongBbox == null) {
                try {
                    layerLatLongBbox = layerInfo.getLatLongBoundingBox();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return layerLatLongBbox;
        }

        private KMLLookAt parseLookAtOptions(GetMapRequest request) {
            KMLLookAt lookAt;
            if (request.getFormatOptions() == null) {
                lookAt = new KMLLookAt();
            } else {
                HashMap<String, Object> formatOptions = new HashMap<String, Object>(request.getFormatOptions());
                lookAt = new KMLLookAt(formatOptions);
                request.getFormatOptions().remove("LOOKATBBOX");
                request.getFormatOptions().remove("LOOKATGEOM");
            }
            return lookAt;
        }

        protected void encodeAsSuperOverlay(GetMapRequest request, KMLLookAt lookAt, List<ReferencedEnvelope> layerBounds) {
            List<MapLayerInfo> layers = request.getLayers();
            List<Style> styles = request.getStyles();
            for (int i = 0; i < layers.size(); ++i) {
                MapLayerInfo layer = layers.get(i);
                if ("cached".equals(KMLUtils.getSuperoverlayMode(request, KMLNetworkLinkTransformer.this.wms)) && KMLUtils.isRequestGWCCompatible(request, i, KMLNetworkLinkTransformer.this.wms)) {
                    this.encodeGWCLink(request, layer);
                    continue;
                }
                String styleName = i < styles.size() ? styles.get(i).getName() : null;
                ReferencedEnvelope bounds = layerBounds.get(i);
                this.encodeLayerSuperOverlay(request, layer, styleName, i, bounds, lookAt);
            }
        }

        public void encodeGWCLink(GetMapRequest request, MapLayerInfo layer) {
            this.start("NetworkLink");
            String prefixedName = layer.getResource().getPrefixedName();
            this.element("name", "GWC-" + prefixedName);
            this.start("Link");
            String type = layer.getType() == MapLayerInfo.TYPE_RASTER ? "png" : "kml";
            String url = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)("gwc/service/kml/" + prefixedName + "." + type + ".kml"), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.element("href", url);
            this.element("viewRefreshMode", "never");
            this.end("Link");
            this.end("NetworkLink");
        }

        private void encodeLayerSuperOverlay(GetMapRequest request, MapLayerInfo layer, String styleName, int layerIndex, ReferencedEnvelope bounds, KMLLookAt lookAt) {
            this.start("NetworkLink");
            this.element("name", layer.getName());
            this.element("open", "1");
            this.element("visibility", "1");
            if (bounds != null) {
                this.encodeLookAt((Envelope)bounds, lookAt);
            }
            this.start("Region");
            Envelope bbox = request.getBbox();
            this.start("LatLonAltBox");
            this.element("north", "" + bbox.getMaxY());
            this.element("south", "" + bbox.getMinY());
            this.element("east", "" + bbox.getMaxX());
            this.element("west", "" + bbox.getMinX());
            this.end("LatLonAltBox");
            this.start("Lod");
            this.element("minLodPixels", "128");
            this.element("maxLodPixels", "-1");
            this.end("Lod");
            this.end("Region");
            this.start("Link");
            String href = WMSRequests.getGetMapUrl(request, layer.getName(), layerIndex, styleName, null, null);
            try {
                href = URLDecoder.decode(href, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.start("href");
            this.cdata(href);
            this.end("href");
            this.end("Link");
            this.end("NetworkLink");
        }

        protected void encodeAsOverlay(GetMapRequest request, KMLLookAt lookAt, List<ReferencedEnvelope> layerBounds) {
            List<MapLayerInfo> layers = request.getLayers();
            List<Style> styles = request.getStyles();
            for (int i = 0; i < layers.size(); ++i) {
                MapLayerInfo layerInfo = layers.get(i);
                this.start("NetworkLink");
                this.element("name", layerInfo.getName());
                this.element("visibility", "1");
                this.element("open", "1");
                ReferencedEnvelope latLongBoundingBox = layerBounds.get(i);
                if (latLongBoundingBox != null) {
                    this.encodeLookAt((Envelope)latLongBoundingBox, lookAt);
                }
                this.start("Url");
                request.setBbox(null);
                String style = i < styles.size() ? styles.get(i).getName() : null;
                String href = WMSRequests.getGetMapUrl(request, layers.get(i).getName(), i, style, null, null);
                try {
                    href = URLDecoder.decode(href, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                this.start("href");
                this.cdata(href);
                this.end("href");
                this.element("viewRefreshMode", "onStop");
                this.element("viewRefreshTime", "1");
                this.end("Url");
                this.end("NetworkLink");
            }
        }

        private void encodeLookAt(Envelope bounds, KMLLookAt lookAt) {
            Envelope lookAtEnvelope = null;
            if (lookAt.getLookAt() == null) {
                lookAtEnvelope = bounds;
            }
            KMLLookAtTransformer tr = new KMLLookAtTransformer(lookAtEnvelope, KMLNetworkLinkTransformer.this.getIndentation(), KMLNetworkLinkTransformer.this.getEncoding());
            Translator translator = tr.createTranslator(this.contentHandler);
            translator.encode((Object)lookAt);
        }
    }
}

