/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.kml.KMLTransformer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.XMLTransformerMap;
import org.geotools.util.logging.Logging;

public class KMLMapOutputFormat
implements GetMapOutputFormat {
    protected static final Logger LOGGER = Logging.getLogger(KMLMapOutputFormat.class);
    static final MapProducerCapabilities KML_CAPABILITIES = new MapProducerCapabilities(false, false, true, true, null);
    public static final String MIME_TYPE = "application/vnd.google-earth.kml+xml";
    private Set<String> OUTPUT_FORMATS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kml", "kml", "application/vnd.google-earth.kml xml")));
    private WMS wms;

    public KMLMapOutputFormat(WMS wms) {
        this.wms = wms;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.OUTPUT_FORMATS;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public XMLTransformerMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        KMLTransformer transformer = new KMLTransformer(this.wms);
        transformer.setIndentation(3);
        Charset encoding = this.wms.getCharSet();
        transformer.setEncoding(encoding);
        XMLTransformerMap map = new XMLTransformerMap(mapContent, transformer, (Object)mapContent, MIME_TYPE);
        map.setContentDispositionHeader(mapContent, ".kml");
        return map;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return KML_CAPABILITIES;
    }
}

