/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.geoserver.kml.KMLLookAt;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;

class KMLLookAtTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    private Envelope targetBounds;

    public KMLLookAtTransformer(Envelope targetBounds, int indentation, Charset charset) {
        this.targetBounds = targetBounds;
        this.setIndentation(indentation);
        this.setEncoding(charset);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new LookAtTranslator(handler);
    }

    private class LookAtTranslator
    extends TransformerBase.TranslatorSupport {
        public LookAtTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            KMLLookAt lookAt = (KMLLookAt)o;
            Envelope lookAtEnvelope = KMLLookAtTransformer.this.targetBounds;
            if (lookAt.getLookAt() != null) {
                Geometry geometry = lookAt.getLookAt();
                lookAtEnvelope = geometry.getEnvelopeInternal();
            }
            if (lookAtEnvelope.isNull()) {
                return;
            }
            double lon1 = lookAtEnvelope.getMinX();
            double lat1 = lookAtEnvelope.getMinY();
            double lon2 = lookAtEnvelope.getMaxX();
            double lat2 = lookAtEnvelope.getMaxY();
            double R_EARTH = 6371000.0;
            double VIEWER_WIDTH = 0.3839724354387525;
            double[] p1 = this.getRect(lon1, lat1, R_EARTH);
            double[] p2 = this.getRect(lon2, lat2, R_EARTH);
            double[] midpoint = new double[]{(p1[0] + p2[0]) / 2.0, (p1[1] + p2[1]) / 2.0, (p1[2] + p2[2]) / 2.0};
            midpoint = this.getGeographic(midpoint[0], midpoint[1], midpoint[2]);
            Double distance = lookAt.getRange();
            if (null == distance) {
                distance = this.distance(p1, p2);
            }
            double height = distance / (2.0 * Math.tan(VIEWER_WIDTH));
            LOGGER.fine("lat1: " + lat1 + "; lon1: " + lon1);
            LOGGER.fine("lat2: " + lat2 + "; lon2: " + lon2);
            LOGGER.fine("latmid: " + midpoint[1] + "; lonmid: " + midpoint[0]);
            Double tilt = lookAt.getTilt() == null ? Double.valueOf(0.0) : lookAt.getTilt();
            Double heading = lookAt.getHeading() == null ? Double.valueOf(0.0) : lookAt.getHeading();
            Double altitude = lookAt.getAltitude() == null ? Double.valueOf(height) : lookAt.getAltitude();
            KMLLookAt.AltitudeMode altMode = lookAt.getAltitudeMode() == null ? KMLLookAt.AltitudeMode.clampToGround : lookAt.getAltitudeMode();
            this.start("LookAt");
            this.element("longitude", String.valueOf(midpoint[0]));
            this.element("latitude", String.valueOf(midpoint[1]));
            this.element("altitude", String.valueOf(altitude));
            this.element("range", String.valueOf(distance));
            this.element("tilt", String.valueOf(tilt));
            this.element("heading", String.valueOf(heading));
            this.element("altitudeMode", String.valueOf((Object)altMode));
            this.end("LookAt");
        }

        private double[] getRect(double lat, double lon, double radius) {
            double theta = (90.0 - lat) * Math.PI / 180.0;
            double phi = (90.0 - lon) * Math.PI / 180.0;
            double x = radius * Math.sin(phi) * Math.cos(theta);
            double y = radius * Math.sin(phi) * Math.sin(theta);
            double z = radius * Math.cos(phi);
            return new double[]{x, y, z};
        }

        private double[] getGeographic(double x, double y, double z) {
            double radius = this.distance(new double[]{x, y, z}, new double[]{0.0, 0.0, 0.0});
            double theta = Math.atan2(Math.sqrt(x * x + y * y), z);
            double phi = Math.atan2(y, x);
            double lat = 90.0 - theta * 180.0 / Math.PI;
            double lon = 90.0 - phi * 180.0 / Math.PI;
            return new double[]{lon > 180.0 ? lon - 360.0 : lon, lat, radius};
        }

        private double distance(double[] p1, double[] p2) {
            double dx = p1[0] - p2[0];
            double dy = p1[1] - p2[1];
            double dz = p1[2] - p2[2];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
    }
}

