/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import org.geoserver.kml.KMLTransformerBase;
import org.geoserver.kml.KMLUtils;
import org.geoserver.wms.WMSMapContent;
import org.geotools.map.Layer;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;

public class KMLLegendTransformer
extends KMLTransformerBase {
    WMSMapContent mapContent;

    public KMLLegendTransformer(WMSMapContent mapContent) {
        this.mapContent = mapContent;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLLegendTranslator(handler);
    }

    class KMLLegendTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        public KMLLegendTranslator(ContentHandler contentHandler) {
            super(contentHandler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            Layer Layer2 = (Layer)o;
            if (KMLLegendTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("ScreenOverlay");
            this.element("name", "Legend");
            this.element("overlayXY", null, KMLUtils.attributes(new String[]{"x", "0", "y", "0", "xunits", "pixels", "yunits", "pixels"}));
            this.element("screenXY", null, KMLUtils.attributes(new String[]{"x", "10", "y", "20", "xunits", "pixels", "yunits", "pixels"}));
            this.start("Icon");
            String legendOptions = KMLLegendTransformer.this.mapContent.getRequest().getRawKvp().get("LEGEND_OPTIONS");
            String[] kvpArray = null;
            if (legendOptions != null) {
                kvpArray = new String[]{"LEGEND_OPTIONS", legendOptions};
            }
            this.element("href", KMLUtils.getLegendGraphicUrl(KMLLegendTransformer.this.mapContent, Layer2, kvpArray));
            this.end("Icon");
            this.end("ScreenOverlay");
            if (KMLLegendTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }
    }
}

