/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import java.util.logging.Level;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.ExternalSortRegionatingStrategy;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;

public class GeometryRegionatingStrategy
extends ExternalSortRegionatingStrategy {
    public GeometryRegionatingStrategy(GeoServer gs) {
        super(gs);
    }

    @Override
    protected void checkAttribute(WMSMapContent con, SimpleFeatureType ft) {
        Map options = con.getRequest().getFormatOptions();
        this.attribute = (String)options.get("regionateAttr");
        if (this.attribute == null) {
            this.attribute = MapLayerInfo.getRegionateAttribute(this.featureType);
        }
        if (this.attribute == null || ft.getDescriptor(this.attribute) == null) {
            LOGGER.log(Level.FINER, "No attribute specified, falling back on geometry attribute");
            this.attribute = ft.getGeometryDescriptor().getLocalName();
        } else {
            AttributeType attributeType = ft.getType(this.attribute);
            if (attributeType == null) {
                throw new ServiceException("Could not find regionating attribute " + this.attribute + " in layer " + this.featureType.getName());
            }
        }
        this.h2Type = "DOUBLE";
    }

    @Override
    protected String checkAttribute(FeatureTypeInfo cfg) {
        String attribute = MapLayerInfo.getRegionateAttribute(cfg);
        try {
            FeatureType ft = cfg.getFeatureType();
            if (attribute != null && ft.getDescriptor(attribute) != null) {
                return attribute;
            }
            return ft.getGeometryDescriptor().getLocalName();
        }
        catch (Exception e) {
            LOGGER.severe("Couldn't get attribute name due to " + e);
            return null;
        }
    }

    @Override
    protected Double getSortAttributeValue(SimpleFeature f) {
        Geometry g = (Geometry)f.getAttribute(this.attribute);
        if (g instanceof MultiPoint) {
            return ((MultiPoint)g).getNumGeometries();
        }
        if (g instanceof Polygon || g instanceof MultiPolygon) {
            return g.getArea();
        }
        return g.getLength();
    }
}

