/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Point;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.GeometryRegionatingStrategy;
import org.geoserver.kml.RandomRegionatingStrategy;
import org.geoserver.kml.RegionatingStrategy;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.map.Layer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class BestGuessRegionatingStrategy
implements RegionatingStrategy {
    GeoServer gs;

    public BestGuessRegionatingStrategy(GeoServer gs) {
        this.gs = gs;
    }

    @Override
    public Filter getFilter(WMSMapContent context, Layer layer) {
        SimpleFeatureType type = (SimpleFeatureType)((SimpleFeatureSource)layer.getFeatureSource()).getSchema();
        Class geomtype = type.getGeometryDescriptor().getType().getBinding();
        if (Point.class.isAssignableFrom(geomtype)) {
            return new RandomRegionatingStrategy(this.gs).getFilter(context, layer);
        }
        return new GeometryRegionatingStrategy(this.gs).getFilter(context, layer);
    }

    @Override
    public void clearCache(FeatureTypeInfo cfg) {
        new GeometryRegionatingStrategy(this.gs).clearCache(cfg);
    }
}

