/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorKMLTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.kml.KMLService;
import org.geowebcache.service.kml.KMZHelper;
import org.geowebcache.storage.StorageBroker;

public class KMLSiteMap {
    private ConveyorKMLTile tile = null;
    private TileLayerDispatcher tLD = null;
    private StorageBroker storageBroker;
    private GridSetBroker gridSetBroker;

    public KMLSiteMap(ConveyorKMLTile tile, TileLayerDispatcher tLD, GridSetBroker gridSetBroker) {
        this.tile = tile;
        this.tLD = tLD;
        this.storageBroker = tile.getStorageBroker();
        this.gridSetBroker = gridSetBroker;
    }

    public void write() throws GeoWebCacheException, IOException {
        this.tile.servletResp.setCharacterEncoding("utf-8");
        this.tile.servletResp.setContentType("application/xml");
        this.tile.servletResp.setStatus(200);
        if (this.tile.getHint() == "sitemap") {
            this.writeSiteMap();
        } else {
            this.writeSiteMapIndex();
        }
    }

    private void writeSiteMapIndex() throws IOException {
        ServletOutputStream os = this.tile.servletResp.getOutputStream();
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
        os.write(header.getBytes());
        this.writeSiteMapIndexLoop();
        String footer = "</sitemapindex>";
        os.write(footer.getBytes());
    }

    private void writeSiteMapIndexLoop() throws IOException {
        ServletOutputStream os = this.tile.servletResp.getOutputStream();
        String urlPrefix = this.tile.getUrlPrefix();
        Iterable iter = this.tLD.getLayerList();
        for (TileLayer tl : iter) {
            if (!tl.isEnabled()) continue;
            Set grids = tl.getGridSubsets();
            List mimeTypes = tl.getMimeTypes();
            if (grids == null || !grids.contains(this.gridSetBroker.WORLD_EPSG4326.getName()) || mimeTypes == null || !mimeTypes.contains(XMLMime.kml)) continue;
            String smStr = "<sitemap><loc>" + urlPrefix + tl.getName() + "/sitemap.xml</loc></sitemap>";
            os.write(smStr.getBytes());
        }
    }

    private void writeSiteMap() throws GeoWebCacheException, IOException {
        TileLayer layer = this.tile.getLayer();
        GridSubset gridSubset = layer.getGridSubset(this.gridSetBroker.WORLD_EPSG4326.getName());
        this.writeSiteMapHeader();
        long[] gridRect = gridSubset.getCoverageBestFit();
        if (gridRect[4] > 0L && (gridRect[2] != gridRect[0] || gridRect[3] != gridRect[1])) {
            throw new GeoWebCacheException(layer.getName() + " is too big for the sub grid set for " + gridSubset.getName() + ", allow for smaller zoom levels.");
        }
        if (gridRect[0] != gridRect[2]) {
            long[] gridLocWest = new long[]{0L, 0L, 0L};
            long[] gridLocEast = new long[]{1L, 0L, 0L};
            this.writeSiteMapLoop(gridLocWest);
            this.writeSiteMapLoop(gridLocEast);
        } else {
            long[] gridLoc = new long[]{gridRect[0], gridRect[1], gridRect[4]};
            this.writeSiteMapLoop(gridLoc);
        }
        this.writeSiteMapFooter();
    }

    private void writeSiteMapHeader() throws IOException {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:geo=\"http://www.google.com/geo/schemas/sitemap/1.0\">\n";
        this.tile.servletResp.getOutputStream().write(header.getBytes());
    }

    private void writeSiteMapFooter() throws IOException {
        String footer = "</urlset>";
        this.tile.servletResp.getOutputStream().write(footer.getBytes());
    }

    public void writeSiteMapLoop(long[] gridLoc) throws GeoWebCacheException, IOException {
        ServletOutputStream os = this.tile.servletResp.getOutputStream();
        TileLayer tileLayer = this.tile.getLayer();
        String urlPrefix = this.tile.getUrlPrefix();
        String superOverlayLoc = "<url><loc>" + urlPrefix.substring(0, urlPrefix.length() - 1) + ".kml.kml</loc><geo:geo><geo:format>kml</geo:format></geo:geo></url>\n";
        os.write(superOverlayLoc.getBytes());
        LinkedList<long[]> subTileList = new LinkedList<long[]>();
        subTileList.addFirst(gridLoc);
        while (subTileList.peek() != null) {
            String gridSetId = this.gridSetBroker.WORLD_EPSG4326.getName();
            long[] curLoc = (long[])subTileList.removeFirst();
            long[][] linkGridLocs = tileLayer.getGridSubset(gridSetId).getSubGrid(curLoc);
            for (long[] subTile : linkGridLocs = KMZHelper.filterGridLocs(this.storageBroker, tileLayer, gridSetId, (MimeType)XMLMime.kml, linkGridLocs)) {
                if (subTile[2] <= 0L) continue;
                subTileList.addLast(subTile);
            }
            String tmp = "<url><loc>" + urlPrefix + KMLService.gridLocString(curLoc) + ".kml" + "</loc><geo:geo><geo:format>kml</geo:format></geo:geo></url>\n";
            os.write(tmp.getBytes());
        }
    }
}

