/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util.requests.readers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.XCQL;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.requests.FilterHandlerImpl;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public abstract class KvpRequestReader {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers");
    private static final String KEYWORD_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    protected static final String OUTER_DELIMETER = "()";
    protected static final String INNER_DELIMETER = ",";
    protected static final FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
    protected Map kvpPairs = new HashMap(10);
    protected ServiceInfo serviceConfig;

    public KvpRequestReader(Map kvpPairs, ServiceInfo service) {
        this.kvpPairs = kvpPairs;
        this.serviceConfig = service;
    }

    protected String getValue(String key) {
        return (String)Converters.convert(this.kvpPairs.get(key), String.class);
    }

    protected boolean keyExists(String key) {
        return this.kvpPairs.containsKey(key);
    }

    public abstract Request getRequest(HttpServletRequest var1) throws ServiceException;

    protected List getTypesFromFids(String rawFidList) {
        ArrayList<String> typeList = new ArrayList<String>(10);
        List unparsed = KvpRequestReader.readNested(rawFidList);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                String fid = innerIterator.next().toString();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("looking at featureId" + fid);
                }
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("adding typename: " + typeName + " from fid");
                }
                typeList.add(typeName);
            }
        }
        return typeList;
    }

    protected static List readFlat(String rawList, String delimiter) {
        return KvpUtils.readFlat((String)rawList, (String)delimiter);
    }

    protected static List readNested(String rawList) {
        return KvpUtils.readNested((String)rawList);
    }

    public static Map parseKvpSet(String qString) {
        String cleanRequest = KvpRequestReader.clean(qString);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("clean request is " + cleanRequest);
        }
        HashMap<String, String> kvps = null;
        kvps = new HashMap<String, String>(10);
        StringTokenizer requestKeywords = new StringTokenizer(cleanRequest.trim(), KEYWORD_DELIMITER);
        while (requestKeywords.hasMoreTokens()) {
            String kvpPair = requestKeywords.nextToken();
            if (kvpPair.toUpperCase().startsWith("FILTER")) {
                String filterVal = kvpPair.substring(7);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("putting filter value " + filterVal);
                }
                kvps.put("FILTER", filterVal);
                continue;
            }
            if (kvpPair.toUpperCase().startsWith("SLD_BODY")) {
                String sldBodyVal = kvpPair.substring(9);
                kvps.put("SLD_BODY", sldBodyVal);
                continue;
            }
            StringTokenizer requestValues = new StringTokenizer(kvpPair, VALUE_DELIMITER);
            if (!requestValues.hasMoreTokens()) continue;
            String key = requestValues.nextToken().toUpperCase();
            if (requestValues.hasMoreTokens()) {
                String value = requestValues.nextToken();
                LOGGER.finest("putting kvp pair: " + key + ": " + value);
                kvps.put(key, value);
                continue;
            }
            kvps.put(key, "");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("returning parsed " + kvps);
        }
        return kvps;
    }

    private static String clean(String raw) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("raw request: " + raw);
        }
        String clean = null;
        if (raw != null) {
            try {
                clean = URLDecoder.decode(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Bad encoding for decoder " + e);
                }
            }
        } else {
            return "";
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("cleaned request: " + raw);
        }
        return clean;
    }

    protected Envelope parseBbox(String bboxParam) throws ServiceException {
        Envelope bbox = null;
        Object[] bboxValues = KvpRequestReader.readFlat(bboxParam, INNER_DELIMETER).toArray();
        if (bboxValues.length != 4) {
            throw new ServiceException(bboxParam + " is not a valid pair of coordinates", this.getClass().getName());
        }
        try {
            double minx = Double.parseDouble(bboxValues[0].toString());
            double miny = Double.parseDouble(bboxValues[1].toString());
            double maxx = Double.parseDouble(bboxValues[2].toString());
            double maxy = Double.parseDouble(bboxValues[3].toString());
            bbox = new Envelope(minx, maxx, miny, maxy);
            if (minx > maxx) {
                throw new ServiceException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
            }
            if (miny > maxy) {
                throw new ServiceException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
            }
        }
        catch (NumberFormatException ex) {
            throw new ServiceException((Throwable)ex, "Illegal value for BBOX parameter: " + bboxParam, this.getClass().getName() + "::parseBbox()");
        }
        return bbox;
    }

    protected List readOGCFilter(String filter) throws ServiceException {
        ArrayList<Object> filters = new ArrayList<Object>();
        LOGGER.finest("reading filter: " + filter);
        List unparsed = KvpRequestReader.readFlat(filter, OUTER_DELIMETER);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            if (next.trim().equals("")) {
                filters.add(Filter.INCLUDE);
                continue;
            }
            filters.add(this.parseXMLFilter(new StringReader(next)));
        }
        return filters;
    }

    protected List readCQLFilter(String filter) throws ServiceException {
        try {
            return XCQL.toFilterList(filter);
        }
        catch (CQLException pe) {
            throw new ServiceException("Could not parse CQL filter list." + pe.getMessage(), (Throwable)pe);
        }
    }

    protected List readFidFilter(String fid) {
        ArrayList<Id> filters = new ArrayList<Id>();
        LOGGER.finest("reading fid filter: " + fid);
        List unparsed = KvpRequestReader.readNested(fid);
        ListIterator i = unparsed.listIterator();
        HashSet<FeatureId> set = new HashSet<FeatureId>();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                set.add(factory.featureId((String)innerIterator.next()));
            }
        }
        Id fidFilter = factory.id(set);
        filters.add(fidFilter);
        LOGGER.finest("added fid filter: " + fidFilter);
        return filters;
    }

    protected Filter parseXMLFilter(Reader rawRequest) throws ServiceException {
        InputSource requestSource = new InputSource(rawRequest);
        FilterHandlerImpl contentHandler = new FilterHandlerImpl();
        FilterFilter filterParser = new FilterFilter((FilterHandler)contentHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler((ContentHandler)documentFilter);
            adapter.parse(requestSource);
            LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getCause() == null) {
                e.initCause(e.getException());
            }
            throw new ServiceException((Throwable)e, "XML getFeature request SAX parsing error", XmlRequestReader.class.getName());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "XML get feature request input error", XmlRequestReader.class.getName());
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException((Throwable)e, "Some sort of issue creating parser", XmlRequestReader.class.getName());
        }
        LOGGER.fine("passing filter: " + contentHandler.getFilter());
        return contentHandler.getFilter();
    }
}

