/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.util.logging.Logging;

public final class ResponseUtils {
    static Logger LOGGER = Logging.getLogger(ResponseUtils.class);

    public static String encodeXML(String inData) {
        return org.geoserver.ows.util.ResponseUtils.encodeXML((String)inData);
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        org.geoserver.ows.util.ResponseUtils.writeEscapedString((Writer)writer, (String)string);
    }

    public static String proxifyMetadataLink(MetadataLinkInfo link, String baseURL) {
        String content = link.getContent();
        try {
            URI uri = new URI(content);
            try {
                if (uri.getHost() == null) {
                    Map kvp = null;
                    if (uri.getQuery() != null && !"".equals(uri.getQuery())) {
                        kvp = KvpUtils.parseQueryString((String)("?" + uri.getQuery()));
                    }
                    content = org.geoserver.ows.util.ResponseUtils.buildURL((String)baseURL, (String)uri.getPath(), kvp, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to create proper back referece for metadata url: " + content, e);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return content;
    }
}

