/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import java.util.List;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.GeoServerFeatureSource;

public class GeoServerFeatureStore
extends GeoServerFeatureSource
implements SimpleFeatureStore {
    GeoServerFeatureStore(FeatureStore<SimpleFeatureType, SimpleFeature> store, SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        super((FeatureSource<SimpleFeatureType, SimpleFeature>)store, schema, definitionQuery, declaredCRS, srsHandling);
    }

    SimpleFeatureStore store() {
        return (SimpleFeatureStore)this.source;
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> fc) throws IOException {
        SimpleFeatureStore store = this.store();
        if (!((SimpleFeatureType)store.getSchema()).equals(fc.getSchema())) {
            fc = new RetypingFeatureCollection(DataUtilities.simple(fc), (SimpleFeatureType)store.getSchema());
        }
        return this.store().addFeatures(fc);
    }

    public void removeFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().removeFeatures(filter);
    }

    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(type, value, filter);
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(type, value, filter);
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        SimpleFeatureStore store = this.store();
        if (!((SimpleFeatureType)store.getSchema()).equals(reader.getFeatureType())) {
            reader = new RetypingFeatureCollection.RetypingFeatureReader(reader, (SimpleFeatureType)store.getSchema());
        }
        this.store().setFeatures(reader);
    }

    public void setTransaction(Transaction transaction) {
        this.store().setTransaction(transaction);
    }

    public Transaction getTransaction() {
        return this.store().getTransaction();
    }

    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(name, attributeValue, filter);
    }

    public void modifyFeatures(String[] names, Object[] attributeValues, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(names, attributeValues, filter);
    }

    public void modifyFeatures(Name[] attributeNames, Object[] attributeValues, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(attributeNames, attributeValues, filter);
    }

    public void modifyFeatures(Name attributeName, Object attributeValue, Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.store().modifyFeatures(attributeName, attributeValue, filter);
    }
}

