/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.IOException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.GeoServerFeatureStore;

public class GeoServerFeatureLocking
extends GeoServerFeatureStore
implements SimpleFeatureLocking {
    GeoServerFeatureLocking(FeatureLocking<SimpleFeatureType, SimpleFeature> locking, SimpleFeatureType schema, Filter definitionQuery, CoordinateReferenceSystem declaredCRS, int srsHandling) {
        super((FeatureStore<SimpleFeatureType, SimpleFeature>)locking, schema, definitionQuery, declaredCRS, srsHandling);
    }

    FeatureLocking<SimpleFeatureType, SimpleFeature> locking() {
        return (FeatureLocking)this.source;
    }

    public void setFeatureLock(FeatureLock lock) {
        if (!(this.source instanceof FeatureLocking)) {
            throw new UnsupportedOperationException("FeatureTypeConfig does not supports locking");
        }
        ((FeatureLocking)this.source).setFeatureLock(lock);
    }

    public int lockFeatures(Query query) throws IOException {
        if (this.source instanceof FeatureLocking) {
            return ((FeatureLocking)this.source).lockFeatures(query);
        }
        throw new DataSourceException("FeatureTypeConfig does not supports locking");
    }

    public int lockFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        return this.locking().lockFeatures(filter);
    }

    public int lockFeatures() throws IOException {
        return this.locking().lockFeatures();
    }

    public void unLockFeatures() throws IOException {
        this.locking().lockFeatures();
    }

    public void unLockFeatures(Filter filter) throws IOException {
        filter = this.makeDefinitionFilter(filter);
        this.locking().unLockFeatures(filter);
    }

    public void unLockFeatures(Query query) throws IOException {
        query = this.makeDefinitionQuery(query, this.schema);
        this.locking().lockFeatures(query);
    }
}

