/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class GeoserverCustomWKTFactory
extends FactoryUsingWKT {
    public static final String SYSTEM_DEFAULT_USER_PROJ_FILE = "user.projections.file";

    protected URL getDefinitionsURL() {
        File proj_file;
        String cust_proj_file = System.getProperty(SYSTEM_DEFAULT_USER_PROJ_FILE);
        if (cust_proj_file == null) {
            cust_proj_file = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), "user_projections/epsg.properties").getAbsolutePath();
        }
        if ((proj_file = new File(cust_proj_file)).exists()) {
            try {
                return proj_file.toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "Had troubles converting file name to URL", e);
            }
        }
        cust_proj_file = "user_epsg.properties";
        return GeoserverCustomWKTFactory.class.getResource(cust_proj_file);
    }
}

