/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import java.util.LinkedList;
import java.util.List;
import org.geoserver.template.FeatureWrapper;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;

public class DirectTemplateFeatureCollectionFactory
implements FeatureWrapper.TemplateFeatureCollectionFactory {
    protected List<FeatureIterator> openIterators = new LinkedList<FeatureIterator>();

    public void purge() {
        while (!this.openIterators.isEmpty()) {
            this.openIterators.get(0).close();
            this.openIterators.remove(0);
        }
    }

    @Override
    public TemplateCollectionModel createTemplateFeatureCollection(FeatureCollection collection, BeansWrapper wrapper) {
        return new TemplateFeatureCollection(collection, wrapper);
    }

    protected class TemplateFeatureIterator
    implements TemplateModelIterator {
        protected BeansWrapper wrapper;
        protected FeatureIterator iterator;

        public TemplateFeatureIterator(FeatureIterator iterator, BeansWrapper wrapper) {
            this.iterator = iterator;
            this.wrapper = wrapper;
        }

        public TemplateModel next() throws TemplateModelException {
            return this.wrapper.wrap((Object)this.iterator.next());
        }

        public boolean hasNext() throws TemplateModelException {
            return this.iterator.hasNext();
        }
    }

    protected class TemplateFeatureCollection
    implements TemplateCollectionModel {
        protected BeansWrapper wrapper;
        protected FeatureCollection collection;

        public TemplateFeatureCollection(FeatureCollection collection, BeansWrapper wrapper) {
            this.collection = collection;
            this.wrapper = wrapper;
        }

        public TemplateModelIterator iterator() throws TemplateModelException {
            return new TemplateFeatureIterator(this.collection.features(), this.wrapper);
        }
    }
}

