/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import java.util.SortedSet;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.AbstractSecurityValidator;
import org.geoserver.security.validation.UserGroupServiceException;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserGroupServiceValidationWrapper
extends AbstractSecurityValidator
implements GeoServerUserGroupService {
    protected GeoServerUserGroupService service;

    public UserGroupServiceValidationWrapper(GeoServerUserGroupService service) {
        super(service.getSecurityManager());
        this.service = service;
    }

    public GeoServerUserGroupService getWrappedService() {
        return this.service;
    }

    protected void checkUserName(String userName) throws IOException {
        if (!this.isNotEmpty(userName)) {
            throw this.createSecurityException("USERNAME_REQUIRED", new Object[0]);
        }
    }

    protected void checkGroupName(String groupName) throws IOException {
        if (!this.isNotEmpty(groupName)) {
            throw this.createSecurityException("GROUPNAME_REQUIRED", new Object[0]);
        }
    }

    protected void checkExistingUserName(String userName) throws IOException {
        this.checkUserName(userName);
        if (this.service.getUserByUsername(userName) == null) {
            throw this.createSecurityException("USER_NOT_FOUND", userName);
        }
    }

    protected void checkExistingGroupName(String groupName) throws IOException {
        this.checkGroupName(groupName);
        if (this.service.getGroupByGroupname(groupName) == null) {
            throw this.createSecurityException("GROUP_NOT_FOUND", groupName);
        }
    }

    protected void checkNotExistingUserName(String userName) throws IOException {
        this.checkUserName(userName);
        if (this.service.getUserByUsername(userName) != null) {
            throw this.createSecurityException("USER_ALREADY_EXISTS", userName);
        }
    }

    protected void checkNotExistingGroupName(String groupName) throws IOException {
        this.checkGroupName(groupName);
        if (this.service.getGroupByGroupname(groupName) != null) {
            throw this.createSecurityException("GROUP_ALREADY_EXISTS", groupName);
        }
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.service.initializeFromConfig(config);
    }

    @Override
    public boolean canCreateStore() {
        return this.service.canCreateStore();
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public void setName(String name) {
        this.service.setName(name);
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.service.setSecurityManager(securityManager);
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        return this.service.createStore();
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.service.getSecurityManager();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.service.loadUserByUsername(username);
    }

    @Override
    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.service.registerUserGroupLoadedListener(listener);
    }

    @Override
    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.service.unregisterUserGroupLoadedListener(listener);
    }

    @Override
    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        return this.service.getGroupByGroupname(groupname);
    }

    @Override
    public GeoServerUser getUserByUsername(String username) throws IOException {
        return this.service.getUserByUsername(username);
    }

    @Override
    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        return this.service.createUserObject(username, password, isEnabled);
    }

    @Override
    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        return this.service.createGroupObject(groupname, isEnabled);
    }

    @Override
    public SortedSet<GeoServerUser> getUsers() throws IOException {
        return this.service.getUsers();
    }

    @Override
    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        return this.service.getUserGroups();
    }

    @Override
    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        this.checkExistingGroupName(group.getGroupname());
        return this.service.getUsersForGroup(group);
    }

    @Override
    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        this.checkExistingUserName(user.getUsername());
        return this.service.getGroupsForUser(user);
    }

    @Override
    public void load() throws IOException {
        this.service.load();
    }

    @Override
    public String getPasswordEncoderName() {
        return this.service.getPasswordEncoderName();
    }

    @Override
    public String getPasswordValidatorName() {
        return this.service.getPasswordValidatorName();
    }

    @Override
    public int getUserCount() throws IOException {
        return this.service.getUserCount();
    }

    @Override
    public int getGroupCount() throws IOException {
        return this.service.getGroupCount();
    }

    protected IOException createSecurityException(String errorid, Object ... args) {
        UserGroupServiceException ex = new UserGroupServiceException(errorid, args);
        return new IOException("Details are in the nested excetpion", (Throwable)((Object)ex));
    }
}

