/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.MasterPasswordProvider;
import org.geoserver.security.config.PasswordPolicyConfig;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.PasswordValidator;
import org.geoserver.security.validation.AbstractSecurityValidator;
import org.geoserver.security.validation.SecurityConfigException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.util.StringUtils;

public class SecurityConfigValidator
extends AbstractSecurityValidator {
    public SecurityConfigValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    public static SecurityConfigValidator getConfigurationValiator(Class<?> serviceClass, String className) throws SecurityConfigException {
        GeoServerSecurityProvider prov = GeoServerSecurityProvider.getProvider(serviceClass, className);
        if (className == null) {
            throw new SecurityConfigException("CLASSNAME_REQUIRED", new Object[0]);
        }
        return prov.createConfigurationValidator((GeoServerSecurityManager)((Object)GeoServerExtensions.bean(GeoServerSecurityManager.class)));
    }

    public void validateManagerConfig(SecurityManagerConfig config) throws SecurityConfigException {
        String encrypterName = config.getConfigPasswordEncrypterName();
        if (!this.isNotEmpty(encrypterName)) {
            throw this.createSecurityException("PASSWORD_ENCODER_REQUIRED", new Object[0]);
        }
        GeoServerPasswordEncoder encoder = null;
        try {
            encoder = this.manager.loadPasswordEncoder(config.getConfigPasswordEncrypterName());
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw this.createSecurityException("INVALID_PASSWORD_ENCODER", encrypterName);
        }
        if (encoder == null) {
            throw this.createSecurityException("INVALID_PASSWORD_ENCODER", encrypterName);
        }
        if (!encoder.isReversible()) {
            throw this.createSecurityException("INVALID_PASSWORD_ENCODER", encrypterName);
        }
        if (!this.manager.isStrongEncryptionAvailable() && encoder != null && !encoder.isAvailableWithoutStrongCryptogaphy()) {
            throw this.createSecurityException("INVALID_STRONG_CONFIG_PASSWORD_ENCODER", new Object[0]);
        }
        String roleServiceName = config.getRoleServiceName();
        if (roleServiceName == null) {
            roleServiceName = "";
        }
        try {
            if (!this.manager.listRoleServices().contains(roleServiceName)) {
                throw this.createSecurityException("ROLE_SERVICE_NOT_FOUND", roleServiceName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SortedSet<String> authProviders = null;
        try {
            authProviders = this.manager.listAuthenticationProviders();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String authProvName : config.getAuthProviderNames()) {
            if (authProviders.contains(authProvName)) continue;
            throw this.createSecurityException("AUTH_PROVIDER_NOT_FOUND", authProvName);
        }
        GeoServerSecurityFilterChain chain = config.getFilterChain();
        if (chain == null) {
            throw this.createSecurityException("FILTER_CHAIN_NULL_ERROR", new Object[0]);
        }
    }

    protected void checkExtensionPont(Class<?> extensionPoint, String className) throws SecurityConfigException {
        if (!this.isNotEmpty(className)) {
            throw this.createSecurityException("CLASSNAME_REQUIRED", new Object[0]);
        }
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw this.createSecurityException("CLASS_NOT_FOUND", className);
        }
        if (!extensionPoint.isAssignableFrom(aClass)) {
            throw this.createSecurityException("CLASS_WRONG_TYPE", extensionPoint, className);
        }
    }

    protected void checkServiceName(Class<?> extensionPoint, String name) throws SecurityConfigException {
        if (name == null || name.isEmpty()) {
            throw this.createSecurityException("NAME_REQUIRED", new Object[0]);
        }
    }

    protected SortedSet<String> getNamesFor(Class<?> extensionPoint) {
        try {
            if (extensionPoint == GeoServerUserGroupService.class) {
                return this.manager.listUserGroupServices();
            }
            if (extensionPoint == GeoServerRoleService.class) {
                return this.manager.listRoleServices();
            }
            if (extensionPoint == GeoServerAuthenticationProvider.class) {
                return this.manager.listAuthenticationProviders();
            }
            if (extensionPoint == AuthenticationProvider.class) {
                return this.manager.listAuthenticationProviders();
            }
            if (extensionPoint == GeoServerSecurityFilter.class) {
                return this.manager.listFilters();
            }
            if (extensionPoint == PasswordValidator.class) {
                return this.manager.listPasswordValidators();
            }
            if (extensionPoint == MasterPasswordProvider.class) {
                return this.manager.listMasterPasswordProviders();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("Unkwnown extension point: " + extensionPoint.getName());
    }

    public void validateAddNamedService(Class<?> extensionPoint, SecurityNamedServiceConfig config) throws SecurityConfigException {
        this.checkExtensionPont(extensionPoint, config.getClassName());
        this.checkServiceName(extensionPoint, config.getName());
        SortedSet<String> names = this.getNamesFor(extensionPoint);
        if (names.contains(config.getName())) {
            throw this.createSecurityException(this.alreadyExistsErrorCode(extensionPoint), config.getName());
        }
    }

    public void validateModifiedNamedService(Class<?> extensionPoint, SecurityNamedServiceConfig config) throws SecurityConfigException {
        this.checkExtensionPont(extensionPoint, config.getClassName());
        this.checkServiceName(extensionPoint, config.getName());
        SortedSet<String> names = this.getNamesFor(extensionPoint);
        if (!names.contains(config.getName())) {
            throw this.createSecurityException(this.notFoundErrorCode(extensionPoint), config.getName());
        }
    }

    public void validateRemoveNamedService(Class<?> extensionPoint, SecurityNamedServiceConfig config) throws SecurityConfigException {
        this.checkServiceName(extensionPoint, config.getName());
    }

    public void validateAddUserGroupService(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        this.validateAddNamedService(GeoServerUserGroupService.class, config);
        this.validate(config);
    }

    public void validateAddRoleService(SecurityRoleServiceConfig config) throws SecurityConfigException {
        this.validateAddNamedService(GeoServerRoleService.class, config);
        this.validate(config);
    }

    public void validateAddPasswordPolicy(PasswordPolicyConfig config) throws SecurityConfigException {
        this.validateAddNamedService(PasswordValidator.class, config);
        this.validate(config);
    }

    public void validateAddAuthProvider(SecurityAuthProviderConfig config) throws SecurityConfigException {
        this.validateAddNamedService(GeoServerAuthenticationProvider.class, config);
        this.validate(config);
    }

    public void validateAddFilter(SecurityNamedServiceConfig config) throws SecurityConfigException {
        this.validateAddNamedService(GeoServerSecurityFilter.class, config);
    }

    public void validateAddMasterPasswordProvider(MasterPasswordProviderConfig config) throws SecurityConfigException {
        this.validateAddNamedService(MasterPasswordProvider.class, config);
        this.validate(config);
    }

    public void validateModifiedUserGroupService(SecurityUserGroupServiceConfig config, SecurityUserGroupServiceConfig oldConfig) throws SecurityConfigException {
        this.validateModifiedNamedService(GeoServerUserGroupService.class, config);
        this.validate(config);
    }

    public void validateModifiedRoleService(SecurityRoleServiceConfig config, SecurityRoleServiceConfig oldConfig) throws SecurityConfigException {
        this.validateModifiedNamedService(GeoServerRoleService.class, config);
        this.validate(config);
    }

    public void validateModifiedPasswordPolicy(PasswordPolicyConfig config, PasswordPolicyConfig oldConfig) throws SecurityConfigException {
        this.validateModifiedNamedService(PasswordValidator.class, config);
        this.validate(config);
    }

    public void validateModifiedAuthProvider(SecurityAuthProviderConfig config, SecurityAuthProviderConfig oldconfig) throws SecurityConfigException {
        this.validateModifiedNamedService(GeoServerAuthenticationProvider.class, config);
        this.validate(config);
    }

    public void validateModifiedFilter(SecurityNamedServiceConfig config, SecurityNamedServiceConfig oldConfig) throws SecurityConfigException {
        this.validateModifiedNamedService(GeoServerSecurityFilter.class, config);
    }

    public void validateModifiedMasterPasswordProvider(MasterPasswordProviderConfig config, MasterPasswordProviderConfig oldConfig) throws SecurityConfigException {
        this.validateModifiedNamedService(MasterPasswordProvider.class, config);
        this.validate(config);
    }

    public void validateRemoveUserGroupService(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        this.validateRemoveNamedService(GeoServerUserGroupService.class, config);
        try {
            for (String name : this.manager.listAuthenticationProviders()) {
                SecurityAuthProviderConfig authConfig = this.manager.loadAuthenticationProviderConfig(name);
                String userGroupService = authConfig.getUserGroupServiceName();
                if (!this.isNotEmpty(userGroupService) || !authConfig.getUserGroupServiceName().equals(config.getName())) continue;
                throw this.createSecurityException("USERGROUP_SERVICE_ACTIVE", config.getName(), authConfig.getName());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void validateRemoveRoleService(SecurityRoleServiceConfig config) throws SecurityConfigException {
        this.validateRemoveNamedService(GeoServerRoleService.class, config);
        if (this.manager.getActiveRoleService().getName().equals(config.getName())) {
            throw this.createSecurityException("ROLE_SERVICE_ACTIVE", config.getName());
        }
    }

    public void validateRemovePasswordPolicy(PasswordPolicyConfig config) throws SecurityConfigException {
        this.validateRemoveNamedService(PasswordValidator.class, config);
        if ("master".equals(config.getName())) {
            throw this.createSecurityException("PASSWD_POLICY_MASTER_DELETE", new Object[0]);
        }
        try {
            for (String name : this.manager.listUserGroupServices()) {
                SecurityUserGroupServiceConfig ugConfig = this.manager.loadUserGroupServiceConfig(name);
                if (!ugConfig.getPasswordPolicyName().equals(config.getName())) continue;
                throw this.createSecurityException("PASSWD_POLICY_ACTIVE", config.getName(), ugConfig.getName());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void validateRemoveAuthProvider(SecurityAuthProviderConfig config) throws SecurityConfigException {
        this.validateRemoveNamedService(GeoServerAuthenticationProvider.class, config);
        for (GeoServerAuthenticationProvider prov : this.manager.getAuthenticationProviders()) {
            if (!prov.getName().equals(config.getName())) continue;
            throw this.createSecurityException("AUTH_PROVIDER_ACTIVE", config.getName());
        }
    }

    public void validateRemoveFilter(SecurityNamedServiceConfig config) throws SecurityConfigException {
        this.validateRemoveNamedService(GeoServerSecurityFilter.class, config);
        List<String> patterns = this.manager.getSecurityConfig().getFilterChain().patternsForFilter(config.getClassName());
        if (!patterns.isEmpty()) {
            throw this.createSecurityException("FILTER_STILL_USED", config.getName(), StringUtils.arrayToCommaDelimitedString((Object[])patterns.toArray()));
        }
    }

    public void validateRemoveMasterPasswordProvider(MasterPasswordProviderConfig config) throws SecurityConfigException {
        this.validateRemoveNamedService(MasterPasswordProvider.class, config);
    }

    public void validate(SecurityAuthProviderConfig config) throws SecurityConfigException {
        if (this.isNotEmpty(config.getUserGroupServiceName()) && !this.getNamesFor(GeoServerUserGroupService.class).contains(config.getUserGroupServiceName())) {
            throw this.createSecurityException("USERGROUP_SERVICE_NOT_FOUND", config.getUserGroupServiceName());
        }
    }

    public void validate(SecurityRoleServiceConfig config) throws SecurityConfigException {
        for (GeoServerRole systemRole : GeoServerRole.SystemRoles) {
            if (systemRole.getAuthority().equals(config.getAdminRoleName())) {
                throw this.createSecurityException("RESERVED_ROLE_NAME", systemRole.getAuthority());
            }
            if (!systemRole.getAuthority().equals(config.getGroupAdminRoleName())) continue;
            throw this.createSecurityException("RESERVED_ROLE_NAME", systemRole.getAuthority());
        }
    }

    public void validate(SecurityUserGroupServiceConfig config) throws SecurityConfigException {
        String encoderName = config.getPasswordEncoderName();
        GeoServerPasswordEncoder encoder = null;
        if (this.isNotEmpty(encoderName)) {
            try {
                encoder = this.manager.loadPasswordEncoder(encoderName);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw this.createSecurityException("INVALID_CONFIG_PASSWORD_ENCODER", encoderName);
            }
            if (encoder == null) {
                throw this.createSecurityException("INVALID_CONFIG_PASSWORD_ENCODER", encoderName);
            }
        } else {
            throw this.createSecurityException("PASSWD_ENCODER_REQUIRED", config.getName());
        }
        if (!this.manager.isStrongEncryptionAvailable() && encoder != null && !encoder.isAvailableWithoutStrongCryptogaphy()) {
            throw this.createSecurityException("INVALID_CONFIG_PASSWORD_ENCODER", new Object[0]);
        }
        String policyName = config.getPasswordPolicyName();
        if (!this.isNotEmpty(policyName)) {
            throw this.createSecurityException("PASSWD_POLICY_REQUIRED", config.getName());
        }
        if (!this.getNamesFor(PasswordValidator.class).contains(policyName)) {
            throw this.createSecurityException("PASSWD_POLICY_NOT_FOUND", policyName);
        }
    }

    public void validate(PasswordPolicyConfig config) throws SecurityConfigException {
        if (config.getMinLength() < 0) {
            throw this.createSecurityException("INVALID_MIN_LENGTH", new Object[0]);
        }
        if (config.getMaxLength() != -1 && config.getMinLength() > config.getMaxLength()) {
            throw this.createSecurityException("INVALID_MAX_LENGTH", new Object[0]);
        }
    }

    public void validate(MasterPasswordProviderConfig config) throws SecurityConfigException {
    }

    protected String alreadyExistsErrorCode(Class<?> extPoint) {
        if (GeoServerAuthenticationProvider.class == extPoint) {
            return "AUTH_PROVIDER_ALREADY_EXISTS";
        }
        if (PasswordValidator.class == extPoint) {
            return "PASSWD_POLICY_ALREADY_EXISTS";
        }
        if (GeoServerRoleService.class == extPoint) {
            return "ROLE_SERVICE_ALREADY_EXISTS";
        }
        if (GeoServerUserGroupService.class == extPoint) {
            return "USERGROUP_SERVICE_ALREADY_EXISTS";
        }
        if (GeoServerSecurityFilter.class == extPoint) {
            return "AUTH_FILTER_ALREADY_EXISTS";
        }
        throw new RuntimeException("Unkonw extension point: " + extPoint.getName());
    }

    protected String notFoundErrorCode(Class<?> extPoint) {
        if (GeoServerAuthenticationProvider.class == extPoint) {
            return "AUTH_PROVIDER_NOT_FOUND";
        }
        if (PasswordValidator.class == extPoint) {
            return "PASSWD_POLICY_NOT_FOUND";
        }
        if (GeoServerRoleService.class == extPoint) {
            return "ROLE_SERVICE_NOT_FOUND";
        }
        if (GeoServerUserGroupService.class == extPoint) {
            return "USERGROUP_SERVICE_NOT_FOUND";
        }
        if (GeoServerSecurityFilter.class == extPoint) {
            return "AUTH_FILTER_NOT_FOUND";
        }
        throw new RuntimeException("Unkonw extension point: " + extPoint.getName());
    }

    protected SecurityConfigException createSecurityException(String errorid, Object ... args) {
        return new SecurityConfigException(errorid, args);
    }
}

