/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.File;
import java.io.IOException;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.validation.SecurityConfigException;

public abstract class AbstractSecurityValidator {
    protected GeoServerSecurityManager manager;

    public AbstractSecurityValidator(GeoServerSecurityManager securityManager) {
        this.manager = securityManager;
    }

    protected boolean isNotEmpty(String aString) {
        return aString != null && aString.length() > 0;
    }

    protected boolean isNotEmpty(char[] aString) {
        return aString != null && aString.length > 0;
    }

    public File getTempDir() {
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            return null;
        }
        File tempDir = new File(tempPath);
        if (!tempDir.exists()) {
            return null;
        }
        if (!tempDir.isDirectory()) {
            return null;
        }
        if (!tempDir.canWrite()) {
            return null;
        }
        return tempDir;
    }

    protected boolean checkFile(File file) throws SecurityConfigException {
        File testFile = null;
        try {
            if (file.isAbsolute()) {
                testFile = file;
            } else {
                File tempDir = this.getTempDir();
                if (tempDir == null) {
                    return true;
                }
                testFile = new File(tempDir, file.getPath());
            }
            if (!testFile.exists()) {
                testFile.createNewFile();
                testFile.delete();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

