/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.security.SecureRandom;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class RandomPasswordProvider {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    public static final char[] PRINTABLE_ALPHABET = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~'};
    public static int DefaultPasswordLength = 40;

    public char[] getRandomPassword(int length) {
        if (length <= 0) {
            return null;
        }
        char[] buff = new char[length];
        this.getRandomPassword(buff);
        return buff;
    }

    public char[] getRandomPasswordWithDefaultLength() {
        char[] buff = new char[DefaultPasswordLength];
        this.getRandomPassword(buff);
        return buff;
    }

    public void getRandomPassword(char[] buff) {
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < buff.length; ++i) {
            int index = random.nextInt() % PRINTABLE_ALPHABET.length;
            if (index < 0) {
                index += PRINTABLE_ALPHABET.length;
            }
            buff[i] = PRINTABLE_ALPHABET[index];
        }
    }

    public void getRandomPassword(byte[] buff) {
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < buff.length; ++i) {
            int index = random.nextInt() % PRINTABLE_ALPHABET.length;
            if (index < 0) {
                index += PRINTABLE_ALPHABET.length;
            }
            buff[i] = (byte)PRINTABLE_ALPHABET[index];
        }
    }
}

