/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.authentication.encoding.PlaintextPasswordEncoder;

public class GeoServerPlainTextPasswordEncoder
extends AbstractGeoserverPasswordEncoder {
    @Override
    protected PasswordEncoder createStringEncoder() {
        return new PlaintextPasswordEncoder();
    }

    @Override
    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){
            PlaintextPasswordEncoder encoder = new PlaintextPasswordEncoder();

            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                return this.encoder.isPasswordValid(encPass, new String(rawPass), salt);
            }

            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                return this.encoder.encodePassword(new String(rawPass), salt);
            }
        };
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.PLAIN;
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        return this.removePrefix(encPass);
    }

    @Override
    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        return this.decode(encPass).toCharArray();
    }
}

