/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import org.apache.commons.codec.binary.Base64;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.jasypt.digest.StandardByteDigester;
import org.jasypt.spring.security3.PasswordEncoder;
import org.jasypt.util.password.PasswordEncryptor;
import org.jasypt.util.password.StrongPasswordEncryptor;

public class GeoServerDigestPasswordEncoder
extends AbstractGeoserverPasswordEncoder {
    public GeoServerDigestPasswordEncoder() {
        this.setReversible(false);
    }

    protected PasswordEncoder createStringEncoder() {
        PasswordEncoder encoder = new PasswordEncoder();
        encoder.setPasswordEncryptor((PasswordEncryptor)new StrongPasswordEncryptor());
        return encoder;
    }

    @Override
    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){
            StandardByteDigester digester = new StandardByteDigester();
            {
                this.digester.setAlgorithm("SHA-256");
                this.digester.setIterations(100000);
                this.digester.setSaltSizeBytes(16);
                this.digester.initialize();
            }

            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                return new String(Base64.encodeBase64((byte[])this.digester.digest(SecurityUtils.toBytes(rawPass))));
            }

            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                return this.digester.matches(SecurityUtils.toBytes(rawPass), Base64.decodeBase64((byte[])encPass.getBytes()));
            }
        };
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.DIGEST;
    }
}

