/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;

public class UserGroupStoreHelper {
    public TreeMap<String, GeoServerUser> userMap = new TreeMap();
    public TreeMap<String, GeoServerUserGroup> groupMap = new TreeMap();
    public TreeMap<GeoServerUserGroup, SortedSet<GeoServerUser>> group_userMap = new TreeMap();
    public TreeMap<GeoServerUser, SortedSet<GeoServerUserGroup>> user_groupMap = new TreeMap();

    public GeoServerUser getUserByUsername(String username) throws IOException {
        return this.userMap.get(username);
    }

    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        return this.groupMap.get(groupname);
    }

    public SortedSet<GeoServerUser> getUsers() throws IOException {
        TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        users.addAll(this.userMap.values());
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
        groups.addAll(this.groupMap.values());
        return Collections.unmodifiableSortedSet(groups);
    }

    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        SortedSet<GeoServerUserGroup> groups = this.user_groupMap.get(user);
        if (groups == null) {
            groups = new TreeSet<GeoServerUserGroup>();
        }
        return Collections.unmodifiableSortedSet(groups);
    }

    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        SortedSet<GeoServerUser> users = this.group_userMap.get(group);
        if (users == null) {
            users = new TreeSet<GeoServerUser>();
        }
        return Collections.unmodifiableSortedSet(users);
    }

    public void clearMaps() {
        this.userMap.clear();
        this.groupMap.clear();
        this.user_groupMap.clear();
        this.group_userMap.clear();
    }

    public int getUserCount() throws IOException {
        return this.userMap.size();
    }

    public int getGroupCount() throws IOException {
        return this.groupMap.size();
    }
}

