/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;

public class RoleCalculator {
    protected GeoServerRoleService roleService;
    protected GeoServerUserGroupService userGroupService;

    public RoleCalculator(GeoServerRoleService roleService) {
        this(null, roleService);
    }

    public RoleCalculator(GeoServerUserGroupService userGroupService, GeoServerRoleService roleService) {
        this.userGroupService = userGroupService;
        this.roleService = roleService;
        this.assertRoleServiceNotNull();
    }

    public void setRoleService(GeoServerRoleService service) {
        this.roleService = service;
        this.assertRoleServiceNotNull();
    }

    public GeoServerRoleService getRoleService() {
        return this.roleService;
    }

    public void setUserGroupService(GeoServerUserGroupService service) {
        this.userGroupService = service;
    }

    public GeoServerUserGroupService getUserGroupService() {
        return this.userGroupService;
    }

    protected void assertRoleServiceNotNull() {
        if (this.roleService == null) {
            throw new RuntimeException("role service Service is null");
        }
    }

    public SortedSet<GeoServerRole> calculateRoles(GeoServerUser user) throws IOException {
        HashSet<GeoServerRole> set1 = new HashSet<GeoServerRole>();
        set1.addAll(this.getRoleService().getRolesForUser(user.getUsername()));
        this.addInheritedRoles(set1);
        if (this.getUserGroupService() != null) {
            for (GeoServerUserGroup group : this.getUserGroupService().getGroupsForUser(user)) {
                if (!group.isEnabled()) continue;
                set1.addAll(this.calculateRoles(group));
            }
        }
        SortedSet<GeoServerRole> set2 = this.personalizeRoles(user, set1);
        this.addMappedSystemRoles(set2);
        return set2;
    }

    protected void addMappedSystemRoles(SortedSet<GeoServerRole> set) {
        GeoServerRole groupAdminRole;
        GeoServerRole adminRole = this.roleService.getAdminRole();
        if (adminRole != null && set.contains(adminRole)) {
            set.add(GeoServerRole.ADMIN_ROLE);
        }
        if ((groupAdminRole = this.roleService.getGroupAdminRole()) != null && set.contains(groupAdminRole)) {
            set.add(GeoServerRole.GROUP_ADMIN_ROLE);
        }
    }

    protected void addParentRole(GeoServerRole role, Collection<GeoServerRole> inherited) throws IOException {
        GeoServerRole parentRole = this.getRoleService().getParentRole(role);
        if (parentRole == null) {
            return;
        }
        if (inherited.contains(parentRole)) {
            return;
        }
        inherited.add(parentRole);
        this.addParentRole(parentRole, inherited);
    }

    public SortedSet<GeoServerRole> calculateRoles(GeoServerUserGroup group) throws IOException {
        TreeSet<GeoServerRole> roles = new TreeSet<GeoServerRole>();
        roles.addAll(this.getRoleService().getRolesForGroup(group.getGroupname()));
        this.addInheritedRoles(roles);
        return roles;
    }

    public void addInheritedRoles(Collection<GeoServerRole> coll) throws IOException {
        HashSet<GeoServerRole> inherited = new HashSet<GeoServerRole>();
        for (GeoServerRole role : coll) {
            this.addParentRole(role, inherited);
        }
        coll.addAll(inherited);
    }

    public SortedSet<GeoServerRole> personalizeRoles(GeoServerUser user, Collection<GeoServerRole> roles) throws IOException {
        TreeSet<GeoServerRole> set = new TreeSet<GeoServerRole>();
        for (GeoServerRole role : roles) {
            Properties personalizedProps = this.getRoleService().personalizeRoleParams(role.getAuthority(), role.getProperties(), user.getUsername(), user.getProperties());
            if (personalizedProps == null) {
                set.add(role);
                continue;
            }
            GeoServerRole pRole = this.getRoleService().createRoleObject(role.getAuthority());
            pRole.setUserName(user.getUsername());
            for (Object key : personalizedProps.keySet()) {
                pRole.getProperties().put(key, personalizedProps.get(key));
            }
            set.add(pRole);
        }
        return set;
    }
}

