/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.Properties;
import org.springframework.security.core.GrantedAuthority;

public class GeoServerRole
implements GrantedAuthority,
Comparable<GeoServerRole> {
    public static final GeoServerRole ADMIN_ROLE = new GeoServerRole("ROLE_ADMINISTRATOR");
    public static final GeoServerRole GROUP_ADMIN_ROLE = new GeoServerRole("ROLE_GROUP_ADMIN");
    public static final GeoServerRole AUTHENTICATED_ROLE = new GeoServerRole("ROLE_AUTHENTICATED");
    public static final GeoServerRole ANY_ROLE = new GeoServerRole("*");
    public static final GeoServerRole NULL_ROLE = new GeoServerRole("null");
    public static final GeoServerRole ANONYMOUS_ROLE = new GeoServerRole("ROLE_ANONYMOUS");
    public static final GeoServerRole[] SystemRoles = new GeoServerRole[]{ADMIN_ROLE, GROUP_ADMIN_ROLE, AUTHENTICATED_ROLE, ANONYMOUS_ROLE};
    public static final GeoServerRole[] MappedRoles = new GeoServerRole[]{ADMIN_ROLE, GROUP_ADMIN_ROLE};
    public static final GeoServerRole[] UnAssignableRoles = new GeoServerRole[]{AUTHENTICATED_ROLE, ANONYMOUS_ROLE};
    private static final long serialVersionUID = 1L;
    protected String userName;
    protected Properties properties;
    protected String role;

    public GeoServerRole(String role) {
        this.role = role;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isAnonymous() {
        return this.getUserName() == null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    @Override
    public int compareTo(GeoServerRole o) {
        if (o == null) {
            return 1;
        }
        if (this.getAuthority().equals(o.getAuthority())) {
            if (this.getUserName() == null && o.getUserName() == null) {
                return 0;
            }
            if (this.getUserName() == null) {
                return -1;
            }
            if (o.getUserName() == null) {
                return 1;
            }
            return this.getUserName().compareTo(o.getUserName());
        }
        return this.getAuthority().compareTo(o.getAuthority());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String && this.getUserName() == null) {
            return this.equalsWithoutUserName(obj);
        }
        if (obj instanceof GrantedAuthority && this.getUserName() == null && !(obj instanceof GeoServerRole)) {
            return this.equalsWithoutUserName(obj);
        }
        if (obj instanceof GeoServerRole) {
            return this.compareTo((GeoServerRole)obj) == 0;
        }
        return false;
    }

    public boolean equalsWithoutUserName(Object obj) {
        if (obj instanceof String) {
            return obj.equals(this.role);
        }
        return this.role.equals(((GrantedAuthority)obj).getAuthority());
    }

    public int hashCode() {
        int hash = this.getAuthority().hashCode();
        if (this.getUserName() != null) {
            hash += this.getUserName().hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.getUserName() != null) {
            StringBuffer buff = new StringBuffer(this.role);
            buff.append(" for user ").append(this.getUserName());
            return buff.toString();
        }
        return this.role;
    }

    public String getAuthority() {
        return this.role;
    }
}

