/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.event.RoleLoadedEvent;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleStoreHelper;
import org.springframework.util.StringUtils;

public abstract class AbstractRoleService
extends AbstractGeoServerSecurityService
implements GeoServerRoleService {
    protected String adminRoleName;
    protected String groupAdminRoleName;
    protected RoleStoreHelper helper;
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());

    protected AbstractRoleService() {
        this.helper = new RoleStoreHelper();
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        this.name = config.getName();
        this.adminRoleName = ((SecurityRoleServiceConfig)config).getAdminRoleName();
        this.groupAdminRoleName = ((SecurityRoleServiceConfig)config).getGroupAdminRoleName();
    }

    @Override
    public GeoServerRole getAdminRole() {
        if (!StringUtils.hasLength((String)this.adminRoleName)) {
            return null;
        }
        try {
            return this.getRoleByName(this.adminRoleName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GeoServerRole getGroupAdminRole() {
        if (!StringUtils.hasLength((String)this.groupAdminRoleName)) {
            return null;
        }
        try {
            return this.getRoleByName(this.groupAdminRoleName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GeoServerRoleStore createStore() throws IOException {
        return null;
    }

    @Override
    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SortedSet<GeoServerRole> getRoles() throws IOException {
        return this.helper.getRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        LOGGER.info("Start reloading roles for service named " + this.getName());
        AbstractRoleService abstractRoleService = this;
        synchronized (abstractRoleService) {
            this.deserialize();
        }
        LOGGER.info("Reloading roles successful for service named " + this.getName());
        this.fireRoleLoadedEvent();
    }

    protected abstract void deserialize() throws IOException;

    @Override
    public SortedSet<GeoServerRole> getRolesForUser(String username) throws IOException {
        return this.helper.getRolesForUser(username);
    }

    @Override
    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        return this.helper.getRolesForGroup(groupname);
    }

    @Override
    public GeoServerRole createRoleObject(String role) throws IOException {
        return new GeoServerRole(role);
    }

    @Override
    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return this.helper.getParentRole(role);
    }

    @Override
    public GeoServerRole getRoleByName(String role) throws IOException {
        return this.helper.getRoleByName(role);
    }

    protected void fireRoleLoadedEvent() {
        RoleLoadedEvent event = new RoleLoadedEvent(this);
        for (RoleLoadedListener listener : this.listeners) {
            listener.rolesChanged(event);
        }
    }

    @Override
    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return this.helper.getGroupNamesForRole(role);
    }

    @Override
    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        return this.helper.getUserNamesForRole(role);
    }

    protected void clearMaps() {
        this.helper.clearMaps();
    }

    @Override
    public Map<String, String> getParentMappings() throws IOException {
        return this.helper.getParentMappings();
    }

    @Override
    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        Properties props = null;
        props = new Properties();
        boolean personalized = false;
        for (Object key : roleParams.keySet()) {
            if (userProps.containsKey(key)) {
                props.put(key, userProps.get(key));
                personalized = true;
                continue;
            }
            props.put(key, roleParams.get(key));
        }
        return personalized ? props : null;
    }

    public File getConfigRoot() throws IOException {
        return new File(this.getSecurityManager().getRoleRoot(), this.getName());
    }

    @Override
    public int getRoleCount() throws IOException {
        return this.helper.getRoleCount();
    }
}

