/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;

public class GeoServerSecurityInterceptorFilter
extends GeoServerCompositeFilter {
    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        SecurityInterceptorFilterConfig siConfig = (SecurityInterceptorFilterConfig)config;
        FilterSecurityInterceptor filter = new FilterSecurityInterceptor();
        filter.setAuthenticationManager((AuthenticationManager)this.getSecurityManager());
        ArrayList<Object> voters = new ArrayList<Object>();
        RoleVoter roleVoter = new RoleVoter();
        roleVoter.setRolePrefix("");
        voters.add(roleVoter);
        voters.add(new AuthenticatedVoter());
        AffirmativeBased accessDecisionManager = new AffirmativeBased(voters);
        accessDecisionManager.setAllowIfAllAbstainDecisions(siConfig.isAllowIfAllAbstainDecisions());
        filter.setAccessDecisionManager((AccessDecisionManager)accessDecisionManager);
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)GeoServerExtensions.bean((String)siConfig.getSecurityMetadataSource()));
        try {
            filter.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getNestedFilters().add((Filter)filter);
    }
}

