/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class GeoServerSecurityFilter
extends AbstractGeoServerSecurityService
implements Filter,
BeanNameAware {
    public static final String AUTHENTICATION_ENTRY_POINT_HEADER = "_AUTHENTICATION_ENTRY_POINT_HEADER";
    private String beanName;

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected String authenticateFromCache(AuthenticationCachingFilter filter, HttpServletRequest request) {
        Authentication authFromCache = null;
        String cacheKey = null;
        if (SecurityContextHolder.getContext().getAuthentication() == null && (cacheKey = filter.getCacheKey(request)) != null) {
            authFromCache = this.getSecurityManager().getAuthenticationCache().get(this.getName(), cacheKey);
            if (authFromCache != null) {
                SecurityContextHolder.getContext().setAuthentication(authFromCache);
            } else {
                return cacheKey;
            }
        }
        return null;
    }
}

