/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.config.RequestHeaderAuthenticationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerPreAuthenticatedUserNameFilter;

public class GeoServerRequestHeaderAuthenticationFilter
extends GeoServerPreAuthenticatedUserNameFilter {
    private String principalHeaderAttribute;

    public String getPrincipalHeaderAttribute() {
        return this.principalHeaderAttribute;
    }

    public void setPrincipalHeaderAttribute(String principalHeaderAttribute) {
        this.principalHeaderAttribute = principalHeaderAttribute;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        RequestHeaderAuthenticationFilterConfig authConfig = (RequestHeaderAuthenticationFilterConfig)config;
        this.setPrincipalHeaderAttribute(authConfig.getPrincipalHeaderAttribute());
    }

    @Override
    protected String getPreAuthenticatedPrincipalName(HttpServletRequest request) {
        return request.getHeader(this.getPrincipalHeaderAttribute());
    }
}

