/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;

public class GeoServerLogoutFilter
extends GeoServerCompositeFilter {
    public static final String URL_AFTER_LOGOUT = "/web/";
    public static final String URL_FOR_LOGOUT = "/j_spring_security_logout";

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        RememberMeServices rms = this.securityManager.getRememberMeService();
        LogoutFilter logoutFilter = new LogoutFilter(URL_AFTER_LOGOUT, new LogoutHandler[]{(LogoutHandler)rms, new SecurityContextLogoutHandler()});
        logoutFilter.setFilterProcessesUrl(URL_FOR_LOGOUT);
        try {
            logoutFilter.afterPropertiesSet();
        }
        catch (ServletException e1) {
            throw new IOException(e1);
        }
        this.getNestedFilters().add((Filter)logoutFilter);
    }
}

