/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.config.J2eeAuthenticationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerPreAuthenticationFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleCalculator;

public class GeoServerJ2eeAuthenticationFilter
extends GeoServerPreAuthenticationFilter {
    private String roleServiceName;

    public String getRoleServiceName() {
        return this.roleServiceName;
    }

    public void setRoleServiceName(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        J2eeAuthenticationFilterConfig authConfig = (J2eeAuthenticationFilterConfig)config;
        this.roleServiceName = authConfig.getRoleServiceName();
    }

    @Override
    protected String getPreAuthenticatedPrincipal(HttpServletRequest request) {
        return request.getUserPrincipal() == null ? null : request.getUserPrincipal().getName();
    }

    @Override
    protected Collection<GeoServerRole> getRoles(HttpServletRequest request, String principal) throws IOException {
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        boolean useActiveService = this.getRoleServiceName() == null || this.getRoleServiceName().trim().length() == 0;
        GeoServerRoleService service = useActiveService ? this.getSecurityManager().getActiveRoleService() : this.getSecurityManager().loadRoleService(this.getRoleServiceName());
        for (GeoServerRole role : service.getRoles()) {
            if (!request.isUserInRole(role.getAuthority())) continue;
            roles.add(role);
        }
        RoleCalculator calc = new RoleCalculator(service);
        calc.addInheritedRoles(roles);
        return roles;
    }
}

