/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.config.ExceptionTranslationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.util.StringUtils;

public class GeoServerExceptionTranslationFilter
extends GeoServerCompositeFilter {
    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        ExceptionTranslationFilterConfig authConfig = (ExceptionTranslationFilterConfig)config;
        DynamicAuthenticationEntryPoint ep = new DynamicAuthenticationEntryPoint();
        if (StringUtils.hasLength((String)authConfig.getAuthenticationFilterName())) {
            GeoServerSecurityFilter authFilter = this.getSecurityManager().loadFilter(authConfig.getAuthenticationFilterName());
            ep.setEntryEntryPoint(authFilter.getAuthenticationEntryPoint());
        }
        HttpSessionRequestCache cache = new HttpSessionRequestCache();
        cache.setCreateSessionAllowed(false);
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter((AuthenticationEntryPoint)ep, (RequestCache)cache);
        if (StringUtils.hasLength((String)authConfig.getAccessDeniedErrorPage())) {
            AccessDeniedHandlerImpl accessDeniedHandler = new AccessDeniedHandlerImpl();
            accessDeniedHandler.setErrorPage(authConfig.getAccessDeniedErrorPage());
            filter.setAccessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
        }
        filter.afterPropertiesSet();
        this.getNestedFilters().add((Filter)filter);
    }

    public static class DynamicAuthenticationEntryPoint
    implements AuthenticationEntryPoint {
        protected AuthenticationEntryPoint defaultEntryPoint = new Http403ForbiddenEntryPoint();
        protected AuthenticationEntryPoint entryEntryPoint = null;

        public AuthenticationEntryPoint getEntryEntryPoint() {
            return this.entryEntryPoint;
        }

        public void setEntryEntryPoint(AuthenticationEntryPoint entryEntryPoint) {
            this.entryEntryPoint = entryEntryPoint;
        }

        public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
            AuthenticationEntryPoint aep = (AuthenticationEntryPoint)request.getAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER");
            if (aep != null) {
                request.removeAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER");
            }
            if (this.getEntryEntryPoint() != null) {
                this.getEntryEntryPoint().commence(request, response, authException);
                return;
            }
            if (aep != null) {
                aep.commence(request, response, authException);
                return;
            }
            this.defaultEntryPoint.commence(request, response, authException);
        }
    }
}

